/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.exception.NotFoundException;
import access.model.Authority;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.OrganizationMembershipRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/organization_memberships"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class OrganizationMembershipController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(OrganizationMembershipController.class);
    private final OrganizationMembershipRepository organizationMembershipRepository;

    public OrganizationMembershipController(OrganizationMembershipRepository organizationMembershipRepository) {
        this.organizationMembershipRepository = organizationMembershipRepository;
    }

    @DeleteMapping(value={"/{membership_id}"})
    public ResponseEntity<Map<String, Object>> delete(User user, @PathVariable(value="membership_id") Long membershipId) {
        LOG.debug((Object)"/delete");
        OrganizationMembership organizationMembership = (OrganizationMembership)this.organizationMembershipRepository.findById((Object)membershipId).orElseThrow(() -> new NotFoundException("OrganizationMembership not found"));
        this.confirmOrganizationMembership(user, organizationMembership.getOrganization(), Authority.ADMIN);
        this.organizationMembershipRepository.delete((Object)organizationMembership);
        return Results.deleteResult();
    }

    @PutMapping(value={"", "/"})
    public ResponseEntity<OrganizationMembership> update(User user, @RequestBody OrganizationMembership organizationMembershipUpdate) {
        LOG.debug((Object)"/update");
        OrganizationMembership organizationMembership = (OrganizationMembership)this.organizationMembershipRepository.findById((Object)organizationMembershipUpdate.getId()).orElseThrow(() -> new NotFoundException("OrganizationMembership not found"));
        Authority newAuthority = organizationMembershipUpdate.getAuthority();
        Authority requiredAuthority = Authority.ADMIN.equals((Object)newAuthority) ? Authority.ADMIN : Authority.MEMBER;
        this.confirmOrganizationMembership(user, organizationMembership.getOrganization(), requiredAuthority);
        organizationMembership.setAuthority(newAuthority);
        organizationMembership = (OrganizationMembership)this.organizationMembershipRepository.save((Object)organizationMembership);
        return ResponseEntity.ok((Object)organizationMembership);
    }
}

