/*
 * Decompiled with CFR 0.152.
 */
package access.repository;

import access.model.Organization;
import access.model.OrganizationStatus;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface OrganizationRepository
extends JpaRepository<Organization, Long>,
QueryRewriter {
    public List<Organization> findByNameContainingIgnoreCase(String var1);

    public Optional<Organization> findByManageIdentifier(String var1);

    public List<Organization> findByStatus(OrganizationStatus var1);

    @EntityGraph(attributePaths={"organizationMemberships.user", "invitations.invitee", "joinRequests.user"})
    public Optional<Organization> findUserManagementOrganizationById(Long var1);

    @EntityGraph(attributePaths={"applications.connections"})
    public Optional<Organization> findApplicationsDetailsOrganizationById(Long var1);

    @EntityGraph(attributePaths={"applications"})
    public Optional<Organization> findApplicationsOrganizationById(Long var1);

    @EntityGraph(attributePaths={"organizationMemberships.user"})
    public Optional<Organization> findUsersOfOrganizationById(Long var1);

    @Modifying
    @Query(value="DELETE FROM organizations WHERE id = ?1", nativeQuery=true)
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public void deleteOrganizationById(Long var1);

    @Query(value=" SELECT org.id, org.name, org.schac_home_organization as schacHomeOrganization, org.status, org.created_at as createdAt,\n                    org.manage_identifier as manageIdentifier,\n        (SELECT u.email FROM organization_memberships om JOIN users u ON u.id = om.user_id WHERE om.organization_id = org.id\n        AND om.authority = 'ADMIN' LIMIT 1) AS adminEmail\n  FROM organizations org WHERE MATCH (name, schac_home_organization) against (?1  IN BOOLEAN MODE)\n", countQuery="SELECT count(*) FROM organizations WHERE MATCH (name, schac_home_organization) against (?1  IN BOOLEAN MODE)", queryRewriter=OrganizationRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPageWithKeyword(String var1, Pageable var2);

    @Query(value=" SELECT org.id, org.name, org.schac_home_organization as schacHomeOrganization, org.status, org.created_at as createdAt,\n                    org.manage_identifier as manageIdentifier,\n        (SELECT u.email FROM organization_memberships om JOIN users u ON u.id = om.user_id WHERE om.organization_id = org.id\n        AND om.authority = 'ADMIN' LIMIT 1) AS adminEmail\n  FROM organizations org\n", countQuery="SELECT count(*) FROM organizations", queryRewriter=OrganizationRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPage(Pageable var1);

    @Query(value=" SELECT org.id, org.name,\n    (SELECT COUNT(*) FROM organization_memberships om WHERE om.organization_id = org.id) as memberCount,\n    (SELECT COUNT(*) FROM applications a WHERE a.organization_id = org.id) as applicationCount\n  FROM organizations org WHERE MATCH (name, schac_home_organization) against (?1  IN BOOLEAN MODE)\n", nativeQuery=true)
    public List<Map<String, Object>> searchWithKeyword(String var1);

    default public String rewrite(String query, Sort sort) {
        Sort.Order adminEmailSort = sort.getOrderFor("adminEmail");
        if (adminEmailSort != null) {
            return query.replace("order by org.adminEmail", "order by adminEmail");
        }
        return query;
    }
}

