/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.exception.InvalidInputException;
import access.exception.UserRestrictionException;
import access.manage.ChangeRequest;
import access.manage.Manage;
import access.manage.ManageData;
import access.manage.MetaData;
import access.manage.MetaDataFeedParser;
import access.manage.PolicyAccessRights;
import access.manage.PolicyDefinition;
import access.model.EntityType;
import access.model.Environment;
import access.model.User;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Parameter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/manage"}, produces={"application/json"})
public class ManageController
implements UserAccessRights,
PolicyAccessRights {
    private static final Log LOG = LogFactory.getLog(ManageController.class);
    private final MetaDataFeedParser metaDataFeedParser = new MetaDataFeedParser();
    private final Manage manage;
    private final ObjectMapper objectMapper;
    private final Map<String, Object> arpInfo;
    private final List<Map<String, Object>> privacyInfo;

    public ManageController(Manage manage, ObjectMapper objectMapper) {
        this.manage = manage;
        this.objectMapper = objectMapper;
        this.arpInfo = (Map)objectMapper.readValue(new ClassPathResource("/metadata/ARP.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.privacyInfo = (List)objectMapper.readValue(new ClassPathResource("/metadata/Privacy.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GetMapping(value={"/arp"})
    public ResponseEntity<Map<String, Object>> arp() {
        LOG.debug((Object)"/arp");
        return ResponseEntity.ok((Object)this.arpInfo);
    }

    @GetMapping(value={"/privacy"})
    public ResponseEntity<List<Map<String, Object>>> privacy() {
        LOG.debug((Object)"/privacy");
        return ResponseEntity.ok((Object)this.privacyInfo);
    }

    @PostMapping(value={"/parse"})
    public ResponseEntity<List<MetaData>> parse(@RequestBody Map<String, String> requestBody) {
        ByteArrayResource resource;
        LOG.debug((Object)"/parse");
        if (requestBody.containsKey("url")) {
            URL url = new URI(requestBody.get("url")).toURL();
            String protocol = url.getProtocol().toLowerCase();
            if (!List.of("http", "https").contains(protocol)) {
                throw new InvalidInputException("Not allowed protocol: " + protocol);
            }
            resource = new UrlResource(url);
        } else {
            String xml = requestBody.get("xml");
            resource = new ByteArrayResource(xml.getBytes(Charset.defaultCharset()));
        }
        List entityDescriptors = this.metaDataFeedParser.importXML((Resource)resource);
        return ResponseEntity.ok(entityDescriptors.stream().map(MetaData::new).toList());
    }

    @GetMapping(value={"/identity-providers/{environment}"})
    public ResponseEntity<List<Map<String, Object>>> identityProviders(@PathVariable(value="environment") Environment environment) {
        LOG.debug((Object)("/identityProviders for " + String.valueOf(environment)));
        List providers = this.manage.providers(environment, new EntityType[]{EntityType.saml20_idp});
        return ResponseEntity.ok((Object)providers);
    }

    @GetMapping(value={"/identity-provider/policies"})
    public ResponseEntity<List<Map<String, Object>>> identityProviderPolicies(@Parameter(hidden=true) User user) {
        LOG.debug((Object)("/identityProviderPolicies for " + user.getEmail()));
        this.confirmInstitutionAdmin(user);
        List policies = this.manage.policiesByIdentityProvider(user.getAuthenticatingAuthority());
        return ResponseEntity.ok((Object)policies);
    }

    @GetMapping(value={"/policies"})
    public ResponseEntity<List<Map<String, Object>>> policies(@Parameter(hidden=true) User user, @RequestParam(value="entityId") String entityId) {
        Map data;
        boolean noneMatch;
        LOG.debug((Object)("/policies for " + entityId + " for " + user.getEmail()));
        this.confirmInstitutionAdmin(user);
        if (!user.isSuperUser() && (noneMatch = (data = this.getIdentityProvider(user)).getOrDefault("allowedEntities", List.of()).stream().noneMatch(allowedEntity -> ((String)allowedEntity.get("name")).equals(entityId)))) {
            throw new UserRestrictionException(String.format("User %s is not allowed to request policies for %s", user.getEmail(), entityId));
        }
        List policies = this.manage.policiesByServiceProvider(user.getAuthenticatingAuthority(), entityId);
        return ResponseEntity.ok((Object)policies);
    }

    @PostMapping(value={"/policies"})
    public ResponseEntity<Map<String, Object>> createPolicy(User user, @RequestBody Map<String, Object> policy) {
        LOG.debug((Object)("/createPolicy for " + String.valueOf(policy) + " for " + user.getEmail()));
        this.policyAccessAllowed(user, policy);
        return ResponseEntity.ok((Object)this.manage.createPolicy(policy));
    }

    @PutMapping(value={"/policies"})
    public ResponseEntity<Map<String, Object>> updatePolicy(User user, @RequestBody Map<String, Object> policy) {
        LOG.debug((Object)("/updatePolicy for " + String.valueOf(policy) + " for " + user.getEmail()));
        this.policyAccessAllowed(user, policy);
        return ResponseEntity.ok((Object)this.manage.updatePolicy(policy));
    }

    @DeleteMapping(value={"/policies/{policyId}"})
    public ResponseEntity<Void> deletePolicy(User user, @PathVariable String policyId) {
        Map policy = this.manage.providerById(EntityType.policy, policyId, Environment.PROD);
        LOG.debug((Object)("/deletePolicy for " + String.valueOf(policy) + " for " + user.getEmail()));
        this.policyAccessAllowed(user, policy);
        this.manage.deletePolicy(policy);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/unique-entity-id/{environment}"})
    public ResponseEntity<List<Map<String, Object>>> providersByEntityId(@PathVariable(value="environment") Environment environment, @RequestBody Map<String, String> data) {
        LOG.debug((Object)("/unique-entity-id for " + String.valueOf(data)));
        String entityID = data.get("entityID");
        List providers = this.manage.uniqueEntityId(environment, EntityType.saml20_sp, entityID);
        return ResponseEntity.ok((Object)providers);
    }

    @PostMapping(value={"/unique-policy-name"})
    public ResponseEntity<List<Map<String, Object>>> uniquePolicyName(@RequestBody Map<String, Object> properties) {
        LOG.debug((Object)("/unique-entity-id for " + String.valueOf(properties)));
        List policies = this.manage.uniquePolicyName(properties);
        return ResponseEntity.ok((Object)policies);
    }

    @GetMapping(value={"/allowed-attributes"})
    public ResponseEntity<List<Map<String, Object>>> allowedAttributes() {
        LOG.debug((Object)"/allowedAttributes");
        return ResponseEntity.ok((Object)this.manage.allowedAttributes());
    }

    @PutMapping(value={"/reject-change-request"})
    public ResponseEntity<Map<String, Object>> rejectChangeRequest(User user, @RequestBody ChangeRequest changeRequest) {
        LOG.debug((Object)("/reject-change-request " + String.valueOf(changeRequest) + " by " + user.getEmail()));
        this.manage.rejectChangeRequest(Environment.PROD, changeRequest);
        return Results.okResult();
    }

    private void policyAccessAllowed(User user, Map<String, Object> policy) {
        this.confirmInstitutionAdmin(user);
        PolicyDefinition policyDefinition = (PolicyDefinition)this.objectMapper.convertValue(policy.get("data"), PolicyDefinition.class);
        this.confirmPolicyAccess(user, policyDefinition, this.manage);
    }

    private Map<String, Object> getIdentityProvider(User user) {
        Map identityProvider = this.manage.identityProviderByEntityID(user.getAuthenticatingAuthority());
        return ManageData.getData((Map)identityProvider);
    }
}

