/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.exception.InvalidInputException;
import access.mail.MailBox;
import access.model.User;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/feedback"})
public class FeedbackController {
    private static final long MAX_SCREENSHOT_BYTES = 0x500000L;
    private static final String SCREENSHOT_CONTENT_TYPE = "image/png";
    private final MailBox mailBox;

    public FeedbackController(MailBox mailBox) {
        this.mailBox = mailBox;
    }

    @PostMapping
    public ResponseEntity<Map<String, Object>> feedback(User user, @RequestBody Map<String, Object> body) throws IOException {
        String message = (String)body.get("message");
        String url = (String)body.get("url");
        boolean includeScreenshot = Boolean.parseBoolean(String.valueOf(body.getOrDefault("includeScreenshot", "false")));
        String screenshotBase64 = (String)body.get("screenshotBase64");
        String screenshotContentType = (String)body.getOrDefault("screenshotContentType", SCREENSHOT_CONTENT_TYPE);
        if (!StringUtils.hasText((String)message)) {
            throw new InvalidInputException("Feedback message is required");
        }
        byte[] screenshotBytes = null;
        String screenshotName = null;
        if (includeScreenshot && StringUtils.hasText((String)screenshotBase64)) {
            if (!SCREENSHOT_CONTENT_TYPE.equalsIgnoreCase(screenshotContentType)) {
                throw new InvalidInputException("Screenshot must be a PNG image");
            }
            try {
                screenshotBytes = Base64.getDecoder().decode(screenshotBase64);
            }
            catch (IllegalArgumentException exception) {
                throw new InvalidInputException("Screenshot is not valid base64");
            }
            if ((long)screenshotBytes.length > 0x500000L) {
                throw new InvalidInputException("Screenshot exceeds max size");
            }
            screenshotName = "feedback.png";
        }
        this.mailBox.sendFeedbackMail(user, message, url, screenshotBytes, screenshotName, screenshotContentType);
        return Results.okResult();
    }
}

