/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.config.Config;
import access.manage.Manage;
import access.manage.ManageData;
import access.model.EntityType;
import access.model.Environment;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/public"}, produces={"application/json"})
public class PublicController {
    private static final Log LOG = LogFactory.getLog(PublicController.class);
    private final Manage manage;
    private final Config config;

    public PublicController(Manage manage, Config config) {
        this.manage = manage;
        this.config = config;
    }

    @GetMapping(value={"/service-providers"})
    public ResponseEntity<List<Map<String, Object>>> serviceProviders(Authentication authentication) {
        LOG.debug((Object)"/serviceProviders");
        List providers = this.manage.serviceProvidersLight(Environment.PROD);
        if (authentication == null) {
            providers.removeIf(provider -> this.removeNonPublicProvider(provider));
        } else {
            DefaultOidcUser user = (DefaultOidcUser)authentication.getPrincipal();
            String schacHomeOrganization = (String)user.getClaims().get("schac_home_organization");
            boolean isExternalUserFromSchacHome = schacHomeOrganization.equals(this.config.getEduIdSchacHomeOrganization());
            if (isExternalUserFromSchacHome) {
                providers.removeIf(provider -> this.removeNonPublicProvider(provider));
            } else {
                String authenticatingAuthority = (String)user.getClaims().get("authenticating_authority");
                Map identityProvider = this.manage.identityProviderByEntityID(authenticatingAuthority);
                Set allowedEntities = ManageData.getData((Map)identityProvider).getOrDefault("allowedEntities", List.of()).stream().map(allowedEntity -> (String)allowedEntity.get("name")).collect(Collectors.toSet());
                providers.removeIf(provider -> this.removeNonPublicProvider(provider, allowedEntities));
            }
        }
        return ResponseEntity.ok((Object)providers);
    }

    @GetMapping(value={"/identity-providers"})
    public ResponseEntity<List<Map<String, Object>>> identityProviders() {
        LOG.debug((Object)"/identityProviders");
        return ResponseEntity.ok((Object)this.manage.identityProvidersLight(Environment.PROD));
    }

    @GetMapping(value={"/service-provider-detail/{type}/{identifier}"})
    public ResponseEntity<Map<String, Object>> serviceProviderDetail(@PathVariable(value="type") EntityType entityType, @PathVariable(value="identifier") String identifier) {
        LOG.debug((Object)"/identityProviders");
        Map provider = this.manage.providerById(entityType, identifier, Environment.PROD);
        ManageData.getMetaDataFields((Map)ManageData.getData((Map)provider)).keySet().removeIf(key -> key.startsWith("contacts:"));
        return ResponseEntity.ok((Object)provider);
    }

    private boolean removeNonPublicProvider(Map<String, Object> provider) {
        Map metaDataFields = ManageData.getMetaDataFields((Map)ManageData.getData(provider));
        boolean hidden = metaDataFields.getOrDefault("coin:ss:hidden", false);
        boolean idpVisibleOnly = metaDataFields.getOrDefault("coin:ss:idp_visible_only", false);
        return hidden || idpVisibleOnly;
    }

    private boolean removeNonPublicProvider(Map<String, Object> provider, Set<String> allowedEntities) {
        Map data = ManageData.getData(provider);
        Map metaDataFields = ManageData.getMetaDataFields((Map)data);
        boolean hidden = metaDataFields.getOrDefault("coin:ss:hidden", false);
        boolean idpVisibleOnly = metaDataFields.getOrDefault("coin:ss:idp_visible_only", false);
        return hidden || idpVisibleOnly && !allowedEntities.contains((String)data.get("entityid"));
    }
}

