/*
 * Decompiled with CFR 0.152.
 */
package access.manipulation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record AttributeScriptContext(Map<String, List<String>> attributes, String subjectId) {
    private final Map<String, List<String>> attributes;
    private final String subjectId;

    public AttributeScriptContext(Map<String, List<String>> attributes, String subjectId) {
        this.attributes = attributes;
        this.subjectId = subjectId;
    }

    public List<String> get(String name) {
        return this.attributes.getOrDefault(name, List.of());
    }

    public void set(String name, List<String> values) {
        this.attributes.put(name, new ArrayList<String>(values));
    }

    public void remove(String name) {
        this.attributes.remove(name);
    }

    public List<String> mapValues(String name, Map<String, String> mapping) {
        return this.get(name).stream().map(mapping::get).filter(Objects::nonNull).toList();
    }

    public Map<String, List<String>> attributes() {
        return this.attributes;
    }

    public String subjectId() {
        return this.subjectId;
    }
}

