/*
 * Decompiled with CFR 0.152.
 */
package aa.config;

import aa.config.AuthorityConfiguration;
import aa.model.Attribute;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.RequiredInputAttribute;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Service
public class AuthorityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorityResolver.class);
    private AuthorityConfiguration configuration;

    @Autowired
    public AuthorityResolver(ResourceLoader resourceLoader, @Value(value="${attribute_authorities_config_path}") String configFileLocation) throws IOException {
        this.parse(resourceLoader, configFileLocation);
        this.references();
        LOG.info("Parsed {} with configuration {}", (Object)configFileLocation, (Object)this.configuration);
    }

    private void parse(ResourceLoader resourceLoader, String configFileLocation) throws IOException {
        Constructor constructor = new Constructor(AuthorityConfiguration.class, new LoaderOptions());
        TypeDescription authorityConfigurationDescription = new TypeDescription(AuthorityConfiguration.class);
        authorityConfigurationDescription.addPropertyParameters("authorities", new Class[]{AttributeAuthorityConfiguration.class});
        TypeDescription attributeAuthorityDescription = new TypeDescription(AttributeAuthorityConfiguration.class);
        authorityConfigurationDescription.addPropertyParameters("attributes", new Class[]{Attribute.class});
        authorityConfigurationDescription.addPropertyParameters("requiredInputAttributes", new Class[]{RequiredInputAttribute.class});
        constructor.addTypeDescription(authorityConfigurationDescription);
        constructor.addTypeDescription(attributeAuthorityDescription);
        this.configuration = (AuthorityConfiguration)new Yaml((BaseConstructor)constructor).load(resourceLoader.getResource(configFileLocation).getInputStream());
    }

    private void references() {
        this.configuration.getAuthorities().forEach(arg_0 -> this.reference(arg_0));
    }

    private void reference(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        attributeAuthorityConfiguration.getAttributes().forEach(attribute -> attribute.setAttributeAuthorityId(attributeAuthorityConfiguration.getId()));
    }

    public AuthorityConfiguration getConfiguration() {
        return this.configuration;
    }
}

