/*
 * Decompiled with CFR 0.152.
 */
package aa.web;

import aa.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import aa.shibboleth.ShibbolethUserDetailService;
import aa.shibboleth.mock.MockShibbolethFilter;
import aa.web.BasicAuthenticationManager;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
@EnableWebSecurity
public class WebSecurityConfigurer {
    @Value(value="${api.lifecycle.username}")
    private String lifeCycleUserName;
    @Value(value="${api.lifecycle.password}")
    private String lifeCyclePassword;
    @Value(value="${security.internal_user_name}")
    private String attributeAggregationUserName;
    @Value(value="${security.internal_password}")
    private String attributeAggregationPassword;

    @Bean
    PasswordEncoder getPasswordEncoder() {
        return NoOpPasswordEncoder.getInstance();
    }

    @Bean
    public AuthenticationManager configureGlobal() {
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        return new ProviderManager(new AuthenticationProvider[]{authenticationProvider});
    }

    @Bean
    public SecurityFilterChain orcidFilterChain(HttpSecurity http, AuthenticationManager authenticationManager, Environment environment) throws Exception {
        http.securityMatcher(new String[]{"/aa/api/redirect", "/aa/api/client/**"}).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED)).csrf(AbstractHttpConfigurer::disable).addFilterBefore((Filter)new ShibbolethPreAuthenticatedProcessingFilter(authenticationManager), AbstractPreAuthenticatedProcessingFilter.class).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated());
        if (environment.acceptsProfiles(Profiles.of((String[])new String[]{"test", "mock"}))) {
            http.addFilterBefore((Filter)new MockShibbolethFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public SecurityFilterChain lifeCycleFilterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.securityMatcher(new String[]{"/aa/api/deprovision/**"}).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf(AbstractHttpConfigurer::disable).addFilterBefore((Filter)new BasicAuthenticationFilter((AuthenticationManager)new BasicAuthenticationManager(this.lifeCycleUserName, this.lifeCyclePassword)), BasicAuthenticationFilter.class).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated()).build();
    }

    @Bean
    public SecurityFilterChain attributeAggregationFilterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.securityMatcher(new String[]{"/aa/api/internal/**"}).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf(AbstractHttpConfigurer::disable).addFilterBefore((Filter)new BasicAuthenticationFilter((AuthenticationManager)new BasicAuthenticationManager(this.attributeAggregationUserName, this.attributeAggregationPassword)), BasicAuthenticationFilter.class).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/internal/health", "/internal/info"})).permitAll().anyRequest()).authenticated()).build();
    }
}

