/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.voot;

import aa.aggregators.AbstractAttributeAggregator;
import aa.aggregators.voot.DefaulltClientRegistrationIdResolver;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.client.OAuth2ClientHttpRequestInterceptor;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.client.RestClient;

public class VootAttributeAggregator
extends AbstractAttributeAggregator {
    public static final String REGISTRATION_ID = "aa";
    private final RestClient restClient;

    public VootAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration, String authorizationAccessTokenUrl) {
        super(attributeAuthorityConfiguration);
        this.restClient = this.vootRestClient(attributeAuthorityConfiguration, authorizationAccessTokenUrl);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        String userUrn = this.getUserAttributeSingleValue(input, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        String url = String.valueOf(this.endpoint()) + "/internal/groups/{userUrn}";
        List objects = (List)this.restClient.get().uri(url, new Object[]{userUrn}).retrieve().body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List groups = objects.stream().map(entry -> (String)entry.get("id")).collect(Collectors.toList());
        this.LOG.debug("Retrieved VOOT groups with request: {} and response: {}", (Object)url, groups);
        return this.mapValuesToUserAttribute("urn:mace:dir:attribute-def:isMemberOf", groups);
    }

    private RestClient vootRestClient(AttributeAuthorityConfiguration configuration, String authorizationAccessTokenUrl) {
        ClientRegistration clientRegistration = this.clientRegistration(configuration, authorizationAccessTokenUrl);
        InMemoryClientRegistrationRepository clientRegistrationRepository = new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
        AuthenticatedPrincipalOAuth2AuthorizedClientRepository authorizedClientRepository = new AuthenticatedPrincipalOAuth2AuthorizedClientRepository((OAuth2AuthorizedClientService)new InMemoryOAuth2AuthorizedClientService((ClientRegistrationRepository)clientRegistrationRepository));
        AuthorizedClientServiceOAuth2AuthorizedClientManager clientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager((ClientRegistrationRepository)clientRegistrationRepository, (OAuth2AuthorizedClientService)new InMemoryOAuth2AuthorizedClientService((ClientRegistrationRepository)clientRegistrationRepository));
        OAuth2ClientHttpRequestInterceptor requestInterceptor = new OAuth2ClientHttpRequestInterceptor((OAuth2AuthorizedClientManager)clientManager);
        OAuth2AuthorizationFailureHandler authorizationFailureHandler = OAuth2ClientHttpRequestInterceptor.authorizationFailureHandler((OAuth2AuthorizedClientRepository)authorizedClientRepository);
        requestInterceptor.setAuthorizationFailureHandler(authorizationFailureHandler);
        requestInterceptor.setClientRegistrationIdResolver((OAuth2ClientHttpRequestInterceptor.ClientRegistrationIdResolver)new DefaulltClientRegistrationIdResolver());
        RestClient.Builder builder = RestClient.builder();
        return builder.requestInterceptor((ClientHttpRequestInterceptor)requestInterceptor).build();
    }

    private ClientRegistration clientRegistration(AttributeAuthorityConfiguration configuration, String authorizationAccessTokenUrl) {
        return ClientRegistration.withRegistrationId((String)REGISTRATION_ID).tokenUri(authorizationAccessTokenUrl).clientId(configuration.getUser()).clientSecret(configuration.getPassword()).scope(new String[]{"groups"}).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
    }
}

