/*
 * Decompiled with CFR 0.152.
 */
package db.mysql.migration;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class V13_0__migrate_many_to_many_applications
extends BaseJavaMigration {
    public void migrate(Context context) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)new SingleConnectionDataSource(context.getConnection(), true));
        jdbcTemplate.query("SELECT id, manage_id, manage_type FROM roles", rs -> {
            long applicationId;
            long roleId = rs.getLong("id");
            GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
            String manageId = rs.getString("manage_id");
            String manageType = rs.getString("manage_type");
            List maps = jdbcTemplate.queryForList("SELECT `id`, `manage_id`, `manage_type` from `applications` WHERE `manage_id` = ? AND `manage_type` = ?", new Object[]{manageId, manageType});
            if (maps.isEmpty()) {
                String sql = "INSERT INTO `applications` (`manage_id`, `manage_type`) VALUES(?, ?)";
                jdbcTemplate.update(conn -> {
                    PreparedStatement preparedStatement = conn.prepareStatement(sql, 1);
                    preparedStatement.setString(1, manageId);
                    preparedStatement.setString(2, manageType);
                    return preparedStatement;
                }, (KeyHolder)generatedKeyHolder);
                applicationId = generatedKeyHolder.getKey().longValue();
            } else {
                applicationId = (Long)((Map)maps.get(0)).get("id");
            }
            jdbcTemplate.update("INSERT INTO `roles_applications` (`role_id`,`application_id`) VALUES (?, ?)", new Object[]{roleId, applicationId});
        });
    }
}

