/*
 * Decompiled with CFR 0.152.
 */
package invite.model;

import invite.model.Authority;
import invite.model.Role;
import invite.model.User;
import invite.model.UserRole;
import invite.model.UserRoleAudit;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import lombok.Generated;

@Entity(name="user_roles_audit")
public class UserRoleAudit {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="user_id", nullable=false)
    private Long userId;
    @Column(name="user_email", nullable=false)
    private String userEmail;
    @Column(name="role_id", nullable=false)
    private Long roleId;
    @Column(name="role_name", nullable=false)
    private String roleName;
    @Column(name="end_date")
    private Instant endDate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="action", nullable=false)
    private ActionType action;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private Authority authority;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="created_by", nullable=false)
    private String createdBy;

    public UserRoleAudit(ActionType action, UserRole userRole, String createdBy) {
        User user = userRole.getUser();
        Role role = userRole.getRole();
        this.userId = user.getId();
        this.userEmail = user.getEmail();
        this.roleId = role.getId();
        this.roleName = role.getName();
        this.endDate = userRole.getEndDate();
        this.action = action;
        this.authority = userRole.getAuthority();
        this.createdAt = Instant.now();
        this.createdBy = createdBy;
    }

    @Generated
    public UserRoleAudit() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserEmail() {
        return this.userEmail;
    }

    @Generated
    public Long getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getRoleName() {
        return this.roleName;
    }

    @Generated
    public Instant getEndDate() {
        return this.endDate;
    }

    @Generated
    public ActionType getAction() {
        return this.action;
    }

    @Generated
    public Authority getAuthority() {
        return this.authority;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    @Generated
    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    @Generated
    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Generated
    public void setEndDate(Instant endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setAction(ActionType action) {
        this.action = action;
    }

    @Generated
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }
}

