/*
 * Decompiled with CFR 0.152.
 */
package invite.provision.eva;

import invite.exception.InvalidInputException;
import invite.model.User;
import invite.provision.Provisioning;
import invite.provision.ProvisioningType;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Comparator;
import lombok.Generated;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class GuestAccount {
    protected static final String EVA_DATE_PATTERN = "yyyy-MM-dd";
    private final MultiValueMap<String, String> request;

    public GuestAccount(User user, Provisioning provisioning) {
        assert (provisioning.getProvisioningType().equals((Object)ProvisioningType.eva)) : "Must be eva provisioning";
        Instant now = Instant.now();
        Instant dateTill = user.userRolesForProvisioning(provisioning).stream().map(userRole -> userRole.getEndDate()).filter(date -> date != null).max(Comparator.naturalOrder()).orElseThrow(() -> new AssertionError((Object)("No userRoles found for provisioning:" + provisioning.getEntityId())));
        if (dateTill.isBefore(now)) {
            throw new InvalidInputException(String.format("dateTill %s is before now %s. No EVA provisioning possible", dateTill, now));
        }
        String language = LocaleContextHolder.getLocale().getLanguage();
        this.request = new LinkedMultiValueMap();
        this.request.add((Object)"name", (Object)user.getName());
        this.request.add((Object)"email", (Object)user.getEmail());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EVA_DATE_PATTERN);
        this.request.add((Object)"dateFrom", (Object)simpleDateFormat.format(Date.from(now)));
        this.request.add((Object)"dateTill", (Object)simpleDateFormat.format(Date.from(dateTill)));
        this.request.add((Object)"notifyByEmail", (Object)Boolean.TRUE.toString());
        this.request.add((Object)"notifyBySms", (Object)Boolean.FALSE.toString());
        this.request.add((Object)"preferredLanguage", (Object)language);
    }

    @Generated
    public MultiValueMap<String, String> getRequest() {
        return this.request;
    }
}

