/*
 * Decompiled with CFR 0.152.
 */
package invite.security;

import invite.exception.ExtendedErrorAttributes;
import invite.manage.Manage;
import invite.provision.ProvisioningService;
import invite.repository.InvitationRepository;
import invite.repository.UserRepository;
import invite.security.AuthorizationRequestCustomizer;
import invite.security.CustomOidcUserService;
import invite.security.ExtendedInMemoryUserDetailsManager;
import invite.security.ExternalApiConfiguration;
import invite.security.LocalDevelopmentAuthenticationFilter;
import jakarta.servlet.Filter;
import java.util.Locale;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.context.DelegatingSecurityContextRepository;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@EnableWebSecurity
@EnableScheduling
@Configuration
@EnableMethodSecurity
@EnableConfigurationProperties(value={ExternalApiConfiguration.class})
public class SecurityConfig {
    public static final String API_TOKEN_HEADER = "X-API-TOKEN";
    private final String eduidEntityId;
    private final String introspectionUri;
    private final String clientId;
    private final String secret;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final InvitationRepository invitationRepository;
    private final ProvisioningService provisioningService;
    private final ExternalApiConfiguration externalApiConfiguration;
    private final Environment environment;
    private final RequestHeaderRequestMatcher apiTokenRequestMatcher = new RequestHeaderRequestMatcher("X-API-TOKEN");

    @Autowired
    public SecurityConfig(ClientRegistrationRepository clientRegistrationRepository, InvitationRepository invitationRepository, ProvisioningService provisioningService, ExternalApiConfiguration externalApiConfiguration, Environment environment, @Value(value="${config.eduid-entity-id}") String eduidEntityId, @Value(value="${oidcng.introspect-url}") String introspectionUri, @Value(value="${oidcng.resource-server-id}") String clientId, @Value(value="${oidcng.resource-server-secret}") String secret) {
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.invitationRepository = invitationRepository;
        this.provisioningService = provisioningService;
        this.eduidEntityId = eduidEntityId;
        this.introspectionUri = introspectionUri;
        this.clientId = clientId;
        this.secret = secret;
        this.externalApiConfiguration = externalApiConfiguration;
        this.environment = environment;
    }

    @Bean
    public CookieSerializer cookieSerializer(@Value(value="${server.servlet.session.cookie.secure}") boolean secure) {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setUseSecureCookie(secure);
        return serializer;
    }

    @Bean
    @Order(value=1)
    SecurityFilterChain sessionSecurityFilterChain(HttpSecurity http, Manage manage, UserRepository userRepository, @Value(value="${institution-admin.entitlement}") String entitlement, @Value(value="${institution-admin.organization-guid-prefix}") String organizationGuidPrefix) throws Exception {
        http.csrf(csrfConfigurer -> csrfConfigurer.ignoringRequestMatchers(new String[]{"/login/oauth2/code/oidcng"}).ignoringRequestMatchers(new String[]{"/api/v1/validations/**"})).securityMatcher(new String[]{"/login/oauth2/**", "/oauth2/authorization/**", "/api/v1/**"}).authorizeHttpRequests(authorizeHttpRequestsConfigurer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequestsConfigurer.requestMatchers(new String[]{"/api/v1/csrf", "/api/v1/disclaimer", "/api/v1/users/config", "/api/v1/users/logout", "/api/v1/invitations/public", "/api/v1/users/ms-accept-return/**", "/api/v1/validations/**", "/ui/**", "/internal/health", "/internal/info"})).permitAll().anyRequest()).authenticated()).oauth2Login(oAuth2LoginConfigurer -> oAuth2LoginConfigurer.authorizationEndpoint(authorization -> authorization.authorizationRequestResolver(this.authorizationRequestResolver(this.clientRegistrationRepository))).userInfoEndpoint(userInfoEndpointConfigurer -> userInfoEndpointConfigurer.oidcUserService((OAuth2UserService)new CustomOidcUserService(manage, userRepository, this.provisioningService, entitlement, organizationGuidPrefix)))).securityContext(securityContextConfigurer -> securityContextConfigurer.securityContextRepository(this.securityContextRepository()));
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"local"}))) {
            http.addFilterBefore((Filter)new LocalDevelopmentAuthenticationFilter(), AnonymousAuthenticationFilter.class);
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public SecurityContextRepository securityContextRepository() {
        return new DelegatingSecurityContextRepository(new SecurityContextRepository[]{new RequestAttributeSecurityContextRepository(), new HttpSessionSecurityContextRepository()});
    }

    private OAuth2AuthorizationRequestResolver authorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        DefaultOAuth2AuthorizationRequestResolver authorizationRequestResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
        authorizationRequestResolver.setAuthorizationRequestCustomizer((Consumer)new AuthorizationRequestCustomizer(this.invitationRepository, this.eduidEntityId));
        return authorizationRequestResolver;
    }

    @Bean
    @Order(value=2)
    SecurityFilterChain basicAuthenticationSecurityFilterChain(HttpSecurity http) throws Exception {
        http.csrf(c -> c.disable()).securityMatcher(new String[]{"/api/voot/**", "/api/external/v1/voot/**", "/api/teams/**", "/api/external/v1/teams/**", "/api/profile/**", "/api/external/v1/profile/**", "/api/aa/**", "/api/external/v1/aa/**", "/api/deprovision/**", "/api/external/v1/deprovision/**", "/api/internal/invite/**", "/api/external/v1/internal/invite/**", "/internal/prometheus"}).sessionManagement(c -> c.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/internal/prometheus"})).hasRole("ACTUATOR")).authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(new RequestMatcher[]{this.apiTokenRequestMatcher})).permitAll().anyRequest()).authenticated()).httpBasic(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=3)
    SecurityFilterChain jwtSecurityFilterChain(HttpSecurity http) throws Exception {
        http.csrf(c -> c.disable()).securityMatcher(new String[]{"/api/external/v1/**"}).authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(new String[]{"/api/external/v1/validations/**"})).permitAll().requestMatchers(new RequestMatcher[]{this.apiTokenRequestMatcher})).permitAll().anyRequest()).authenticated()).sessionManagement(c -> c.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).oauth2ResourceServer(c -> c.opaqueToken(c1 -> c1.introspectionUri(this.introspectionUri).introspectionClientCredentials(this.clientId, this.secret)));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public UserDetailsService userDetailsService() {
        return new ExtendedInMemoryUserDetailsManager(this.externalApiConfiguration.getRemoteUsers());
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver slr = new AcceptHeaderLocaleResolver();
        slr.setDefaultLocale(Locale.ENGLISH);
        return slr;
    }

    @Bean
    ErrorAttributes errorAttributes() {
        return new ExtendedErrorAttributes();
    }
}

