/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.config.Config;
import invite.cron.ResourceCleaner;
import invite.cron.RoleExpirationNotifier;
import invite.exception.NotAllowedException;
import invite.manage.Manage;
import invite.model.Role;
import invite.model.User;
import invite.model.UserRole;
import invite.repository.RoleRepository;
import invite.repository.UserRoleRepository;
import invite.security.UserPermissions;
import invite.seed.PerformanceSeed;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/system", "/api/external/v1/system"}, produces={"application/json"})
@Transactional
@SecurityRequirement(name="openId", scopes={"openid"})
@EnableConfigurationProperties(value={Config.class})
public class SystemController {
    private static final Log LOG = LogFactory.getLog(SystemController.class);
    private final ResourceCleaner resourceCleaner;
    private final RoleExpirationNotifier roleExpirationNotifier;
    private final RoleRepository roleRepository;
    private final UserRoleRepository userRoleRepository;
    private final Manage manage;
    private final PerformanceSeed performanceSeed;
    private final Config config;

    public SystemController(ResourceCleaner resourceCleaner, RoleExpirationNotifier roleExpirationNotifier, RoleRepository roleRepository, UserRoleRepository userRoleRepository, Manage manage, PerformanceSeed performanceSeed, Config config) {
        this.resourceCleaner = resourceCleaner;
        this.roleExpirationNotifier = roleExpirationNotifier;
        this.roleRepository = roleRepository;
        this.userRoleRepository = userRoleRepository;
        this.manage = manage;
        this.performanceSeed = performanceSeed;
        this.config = config;
    }

    @GetMapping(value={"/cron/cleanup"})
    public ResponseEntity<Map<String, List<? extends Serializable>>> cronCleanup(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/cron/cleanup");
        UserPermissions.assertSuperUser((User)user);
        Map body = this.resourceCleaner.doClean();
        return ResponseEntity.ok((Object)body);
    }

    @GetMapping(value={"/cron/expiry-notifications"})
    public ResponseEntity<Map<String, List<String>>> expiryNotifications(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/cron/expiry-notifications");
        UserPermissions.assertSuperUser((User)user);
        return ResponseEntity.ok(Map.of("mails", this.roleExpirationNotifier.doSweep()));
    }

    @GetMapping(value={"/expiry-user-roles"})
    public ResponseEntity<List<UserRole>> expiryUserRoles(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/cron/notifications");
        UserPermissions.assertSuperUser((User)user);
        Instant instant = Instant.now().plus(30L, ChronoUnit.DAYS);
        List userRoles = this.userRoleRepository.findByEndDateBefore(instant);
        userRoles.forEach(userRole -> userRole.setUserInfo(userRole.getUser().asMap()));
        return ResponseEntity.ok((Object)userRoles);
    }

    @GetMapping(value={"/unknown-roles"})
    public ResponseEntity<List<Role>> unknownRoles(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/unknown-roles");
        UserPermissions.assertSuperUser((User)user);
        List roles = this.manage.addManageMetaData(this.roleRepository.findAll());
        List<Role> unknownManageRoles = roles.stream().filter(role -> role.getApplicationMaps().stream().anyMatch(applicationMap -> applicationMap.containsKey("unknown"))).toList();
        return ResponseEntity.ok(unknownManageRoles);
    }

    @PutMapping(value={"/performance-seed"})
    public ResponseEntity<Map<String, Object>> performanceSeed(@Parameter(hidden=true) User user, @RequestParam(value="numberOfRole", required=false, defaultValue="500") int numberOfRole, @RequestParam(value="numberOfUsers", required=false, defaultValue="75000") int numberOfUsers) {
        LOG.debug((Object)"/performance-seed");
        if (!this.config.isPerformanceSeedAllowed()) {
            throw new NotAllowedException("performance-seed not allowed");
        }
        UserPermissions.assertSuperUser((User)user);
        return ResponseEntity.ok((Object)this.performanceSeed.go(numberOfRole, numberOfUsers));
    }
}

