/*
 * Decompiled with CFR 0.152.
 */
package invite.eduid;

import invite.eduid.EduIDProvision;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EduID {
    private static final Log LOG = LogFactory.getLog(EduID.class);
    private final String uri;
    private final RestTemplate restTemplate;
    private final HttpHeaders headers;

    public EduID(@Value(value="${myconext.uri}") String uri, @Value(value="${myconext.username}") String userName, @Value(value="${myconext.password}") String password) {
        this.uri = uri;
        this.restTemplate = new RestTemplate();
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(userName, password));
        this.headers = this.initHttpHeaders();
    }

    public Optional<String> provisionEduid(EduIDProvision eduIDProvision) {
        HttpEntity requestEntity = new HttpEntity((Object)eduIDProvision, (MultiValueMap)this.headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.uri, HttpMethod.POST, requestEntity, EduIDProvision.class, new Object[0]);
            return Optional.of(((EduIDProvision)responseEntity.getBody()).getEduIDValue());
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error in provisionEduid", (Throwable)e);
            return Optional.empty();
        }
    }

    private HttpHeaders initHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }
}

