/*
 * Decompiled with CFR 0.152.
 */
package invite.repository;

import invite.model.Role;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.stereotype.Repository;

@Repository
public interface RoleRepository
extends JpaRepository<Role, Long>,
QueryRewriter {
    @Query(value="SELECT *, (SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=r.id) as userRoleCount FROM roles r WHERE MATCH (name, description) against (?1  IN BOOLEAN MODE) AND id > 0 LIMIT ?2", nativeQuery=true)
    public List<Role> search(String var1, int var2);

    @Query(value="SELECT *,\n    (SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=r.id) as userRoleCount\nFROM roles r\n", countQuery="SELECT COUNT(r.id) FROM roles r\n", queryRewriter=RoleRepository.class, nativeQuery=true)
    public Page<Role> searchByPage(Pageable var1);

    @Query(value="SELECT *,\n    (SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=r.id) as userRoleCount\nFROM roles r WHERE MATCH (name, description) against (?1 IN BOOLEAN MODE)\n", countQuery="SELECT COUNT(r.id) FROM roles r WHERE MATCH (name, description) against (?1 IN BOOLEAN MODE)\n", queryRewriter=RoleRepository.class, nativeQuery=true)
    public Page<Role> searchByPageWithKeyword(String var1, Pageable var2);

    @Query(value="SELECT *,\n    (SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=r.id) AS userRoleCount\nFROM roles r WHERE r.organization_guid = ?1\n", countQuery="SELECT COUNT(r.id) FROM roles r WHERE r.organization_guid = ?1\n", queryRewriter=RoleRepository.class, nativeQuery=true)
    public Page<Role> searchByPageAndOrganizationGUID(String var1, Pageable var2);

    @Query(value="SELECT r.id AS role_id, a.manage_id AS manage_id, a.manage_type AS manage_type\nFROM applications a INNER JOIN application_usages au ON au.application_id = a.id\nINNER JOIN roles r ON au.role_id = r.id WHERE r.id IN ?1\n", nativeQuery=true)
    public List<Map<String, Object>> findApplications(List<Long> var1);

    public List<Role> findByApplicationUsagesApplicationManageId(String var1);

    public List<Role> findByOrganizationGUID(String var1);

    public Optional<Role> findByName(String var1);

    default public String rewrite(String query, Sort sort) {
        Sort.Order userRoleCount = sort.getOrderFor("userRoleCount");
        if (userRoleCount != null) {
            return query.replace(" order by r.userRoleCount", " order by userRoleCount");
        }
        return query;
    }
}

