/*
 * Decompiled with CFR 0.152.
 */
package invite.security;

import invite.model.User;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class InstitutionAdmin {
    public static final String INSTITUTION_ADMIN = "INSTITUTION_ADMIN";
    public static final String ORGANIZATION_GUID = "ORGANIZATION_GUID";
    public static final String APPLICATIONS = "APPLICATIONS";
    public static final String INSTITUTION = "INSTITUTION";

    private InstitutionAdmin() {
    }

    public static boolean isInstitutionAdmin(Map<String, Object> attributes, String requiredEntitlement) {
        if (attributes.containsKey("eduperson_entitlement")) {
            List entitlements = (List)attributes.get("eduperson_entitlement");
            return entitlements.stream().anyMatch(entitlement -> entitlement.equalsIgnoreCase(requiredEntitlement));
        }
        return false;
    }

    public static boolean isInstitutionAdmin(User user) {
        return StringUtils.hasText((String)user.getOrganizationGUID()) && (user.isInstitutionAdmin() || user.isInstitutionAdminByInvite());
    }

    public static Optional<String> getOrganizationGuid(Map<String, Object> attributes, String organizationGuidPrefix, Optional<User> optionalUser) {
        if (attributes.containsKey("eduperson_entitlement")) {
            List entitlements = (List)attributes.get("eduperson_entitlement");
            String organizationGuidPrefixLower = organizationGuidPrefix.toLowerCase();
            Optional<String> optionalOrganizationGuid = entitlements.stream().filter(entitlement -> entitlement.toLowerCase().startsWith(organizationGuidPrefixLower)).map(entitlement -> entitlement.substring(organizationGuidPrefix.length())).filter(StringUtils::hasText).findFirst();
            if (optionalOrganizationGuid.isPresent()) {
                return optionalOrganizationGuid.filter(StringUtils::hasText);
            }
        }
        return optionalUser.map(User::getOrganizationGUID).filter(StringUtils::hasText);
    }
}

