/*
 * Decompiled with CFR 0.152.
 */
package invite.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import invite.model.Application;
import invite.model.ApplicationUsage;
import invite.model.Auditable;
import invite.model.Provisionable;
import invite.model.RoleRequest;
import invite.provision.scim.GroupURN;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.annotations.Formula;

@Entity(name="roles")
public class Role
implements Serializable,
Provisionable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    @NotBlank
    private String name;
    @Column(name="short_name")
    @NotNull
    private String shortName;
    @Column(name="description")
    private String description;
    @Column(name="urn")
    private String urn;
    @Column(name="default_expiry_days")
    private Integer defaultExpiryDays;
    @Column(name="enforce_email_equality")
    private boolean enforceEmailEquality;
    @Column(name="edu_id_only")
    private boolean eduIDOnly;
    @Column(name="block_expiry_date")
    private boolean blockExpiryDate;
    @Column(name="override_settings_allowed")
    private boolean overrideSettingsAllowed;
    @Column(name="teams_origin")
    private boolean teamsOrigin;
    @Column(name="identifier")
    private String identifier;
    @Column(name="organization_guid")
    private String organizationGUID;
    @Column(name="remote_api_user")
    private String remoteApiUser;
    @Column(name="inviter_display_name")
    private String inviterDisplayName;
    @Formula(value="(SELECT COUNT(*) FROM user_roles ur WHERE ur.role_id=id)")
    private Long userRoleCount;
    @OneToMany(mappedBy="role", fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<ApplicationUsage> applicationUsages = new HashSet();
    @Embedded
    private Auditable auditable = new Auditable();
    @Transient
    private List<Map<String, Object>> applicationMaps;

    public Role(Long id, String name, String description, Long userRoleCount, Integer defaultExpiryDays, boolean enforceEmailEquality, boolean eduIDOnly, boolean overrideSettingsAllowed) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.userRoleCount = userRoleCount;
        this.defaultExpiryDays = defaultExpiryDays;
        this.enforceEmailEquality = enforceEmailEquality;
        this.eduIDOnly = eduIDOnly;
        this.overrideSettingsAllowed = overrideSettingsAllowed;
    }

    public Role(String name, String description, Set<ApplicationUsage> applicationUsages, Integer defaultExpiryDays, boolean enforceEmailEquality, boolean eduIDOnly) {
        this(name, GroupURN.sanitizeRoleShortName((String)name), description, applicationUsages, defaultExpiryDays, enforceEmailEquality, eduIDOnly, Collections.emptyList());
    }

    public Role(@NotNull String name, @NotNull String shortName, String description, Set<ApplicationUsage> applicationUsages, Integer defaultExpiryDays, boolean enforceEmailEquality, boolean eduIDOnly, List<Map<String, Object>> applicationMaps) {
        this.name = name;
        this.shortName = shortName;
        this.description = description;
        this.defaultExpiryDays = defaultExpiryDays;
        this.enforceEmailEquality = enforceEmailEquality;
        this.eduIDOnly = eduIDOnly;
        this.applicationUsages = applicationUsages;
        this.applicationUsages.forEach(applicationUsage -> applicationUsage.setRole(this));
        this.applicationMaps = applicationMaps;
        this.identifier = UUID.randomUUID().toString();
    }

    public Role(RoleRequest roleRequest) {
        this.name = roleRequest.getName();
        this.description = roleRequest.getDescription();
        this.defaultExpiryDays = roleRequest.getDefaultExpiryDays();
        this.enforceEmailEquality = roleRequest.isEnforceEmailEquality();
        this.eduIDOnly = roleRequest.isEduIDOnly();
        this.blockExpiryDate = roleRequest.isBlockExpiryDate();
        this.overrideSettingsAllowed = roleRequest.isOverrideSettingsAllowed();
        this.organizationGUID = roleRequest.getOrganizationGUID();
        this.inviterDisplayName = roleRequest.getInviterDisplayName();
        this.applicationUsages = roleRequest.getApplicationUsages();
    }

    @Transient
    @JsonIgnore
    public List<String> applicationIdentifiers() {
        return this.applicationUsages.stream().map(applicationUsage -> applicationUsage.getApplication().getManageId()).toList();
    }

    @Transient
    @JsonIgnore
    public Set<Application> applicationsUsed() {
        return this.applicationUsages.stream().map(ApplicationUsage::getApplication).collect(Collectors.toSet());
    }

    public void setApplicationUsages(Set<ApplicationUsage> applicationUsages) {
        this.applicationUsages = applicationUsages;
        this.applicationUsages.forEach(applicationUsage -> applicationUsage.setRole(this));
    }

    @Generated
    public Role() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUrn() {
        return this.urn;
    }

    @Generated
    public Integer getDefaultExpiryDays() {
        return this.defaultExpiryDays;
    }

    @Generated
    public boolean isEnforceEmailEquality() {
        return this.enforceEmailEquality;
    }

    @Generated
    public boolean isEduIDOnly() {
        return this.eduIDOnly;
    }

    @Generated
    public boolean isBlockExpiryDate() {
        return this.blockExpiryDate;
    }

    @Generated
    public boolean isOverrideSettingsAllowed() {
        return this.overrideSettingsAllowed;
    }

    @Generated
    public boolean isTeamsOrigin() {
        return this.teamsOrigin;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    @Generated
    public String getRemoteApiUser() {
        return this.remoteApiUser;
    }

    @Generated
    public String getInviterDisplayName() {
        return this.inviterDisplayName;
    }

    @Generated
    public Long getUserRoleCount() {
        return this.userRoleCount;
    }

    @Generated
    public Set<ApplicationUsage> getApplicationUsages() {
        return this.applicationUsages;
    }

    @Generated
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Generated
    public List<Map<String, Object>> getApplicationMaps() {
        return this.applicationMaps;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setUrn(String urn) {
        this.urn = urn;
    }

    @Generated
    public void setDefaultExpiryDays(Integer defaultExpiryDays) {
        this.defaultExpiryDays = defaultExpiryDays;
    }

    @Generated
    public void setEnforceEmailEquality(boolean enforceEmailEquality) {
        this.enforceEmailEquality = enforceEmailEquality;
    }

    @Generated
    public void setEduIDOnly(boolean eduIDOnly) {
        this.eduIDOnly = eduIDOnly;
    }

    @Generated
    public void setBlockExpiryDate(boolean blockExpiryDate) {
        this.blockExpiryDate = blockExpiryDate;
    }

    @Generated
    public void setOverrideSettingsAllowed(boolean overrideSettingsAllowed) {
        this.overrideSettingsAllowed = overrideSettingsAllowed;
    }

    @Generated
    public void setTeamsOrigin(boolean teamsOrigin) {
        this.teamsOrigin = teamsOrigin;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    @Generated
    public void setRemoteApiUser(String remoteApiUser) {
        this.remoteApiUser = remoteApiUser;
    }

    @Generated
    public void setInviterDisplayName(String inviterDisplayName) {
        this.inviterDisplayName = inviterDisplayName;
    }

    @Generated
    public void setUserRoleCount(Long userRoleCount) {
        this.userRoleCount = userRoleCount;
    }

    @Generated
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    @Generated
    public void setApplicationMaps(List<Map<String, Object>> applicationMaps) {
        this.applicationMaps = applicationMaps;
    }
}

