/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.config.Config;
import invite.exception.NotFoundException;
import invite.manage.EntityType;
import invite.manage.Manage;
import invite.model.Application;
import invite.model.Authority;
import invite.model.RequestedAuthnContext;
import invite.model.User;
import invite.repository.ApplicationRepository;
import invite.repository.RoleRepository;
import invite.security.UserPermissions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/manage", "/api/external/v1/manage"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class ManageController {
    private static final Log LOG = LogFactory.getLog(ManageController.class);
    private final Manage manage;
    private final ApplicationRepository applicationRepository;
    private final RoleRepository roleRepository;
    private final String eduIDEntityID;

    @Autowired
    public ManageController(Manage manage, ApplicationRepository applicationRepository, RoleRepository roleRepository, @Value(value="${config.eduid-entity-id}") String eduIDEntityID) {
        this.manage = manage;
        this.applicationRepository = applicationRepository;
        this.roleRepository = roleRepository;
        this.eduIDEntityID = eduIDEntityID;
    }

    @GetMapping(value={"/provider/{type}/{id}"})
    public ResponseEntity<Map<String, Object>> providerById(@PathVariable(value="type") EntityType type, @PathVariable(value="id") String id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /manage/provider type: %s, id: %s for user %s", type, id, user.getEduPersonPrincipalName()));
        UserPermissions.assertSuperUser((User)user);
        Map provider = this.manage.providerById(type, id);
        return ResponseEntity.ok((Object)provider);
    }

    @GetMapping(value={"/eduid-identity-provider"})
    public ResponseEntity<Map<String, Object>> eduIDIdentityProvider(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /manage/eduIDIdentityProvider type: %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INVITER);
        Map eduIDIdP = (Map)this.manage.providerByEntityID(EntityType.SAML20_IDP, this.eduIDEntityID).orElseThrow(() -> new NotFoundException("EduID IdP not found: " + this.eduIDEntityID));
        return ResponseEntity.ok((Object)eduIDIdP);
    }

    @GetMapping(value={"/requested-authn-context-values"})
    public ResponseEntity<Map<String, String>> requestedAuthnContextValues() {
        LOG.debug((Object)"GET /manage/requestedAuthnContextValues");
        Map<String, String> values = Stream.of(RequestedAuthnContext.values()).collect(Collectors.toMap(rac -> rac.name(), rac -> rac.getUrl()));
        return ResponseEntity.ok(values);
    }

    @GetMapping(value={"/providers"})
    public ResponseEntity<List<Map<String, Object>>> providers(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /manage/providers for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.SUPER_USER);
        List providers = this.manage.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        return ResponseEntity.ok((Object)providers);
    }

    @GetMapping(value={"/organization-guid-validation/{organizationGUID}"})
    public ResponseEntity<Map<String, Object>> organizationGUIDValidation(@Parameter(hidden=true) User user, @PathVariable(value="organizationGUID") String organizationGUID) {
        LOG.debug((Object)String.format("GET /manage/organization-guid-validation guid: %s for user %s", organizationGUID, user.getEduPersonPrincipalName()));
        UserPermissions.assertSuperUser((User)user);
        List identityProviders = this.manage.identityProvidersByInstitutionalGUID(organizationGUID);
        if (CollectionUtils.isEmpty((Collection)identityProviders)) {
            new NotFoundException("No identity provider with organizationGUID: " + organizationGUID);
        }
        return ResponseEntity.ok((Object)((Map)identityProviders.getFirst()));
    }

    @GetMapping(value={"/applications"})
    @Transactional(readOnly=true)
    public ResponseEntity<Map<String, List<Map<String, Object>>>> applications(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /manage/applications for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertInstitutionAdmin((User)user);
        List<Application> applications = user.isSuperUser() ? this.applicationRepository.findAll() : this.roleRepository.findByOrganizationGUID(user.getOrganizationGUID()).stream().map(role -> role.getApplicationUsages()).flatMap(Collection::stream).map(applicationUsage -> applicationUsage.getApplication()).toList();
        Map<EntityType, List<Application>> groupedByManageType = applications.stream().collect(Collectors.groupingBy(Application::getManageType));
        List providers = groupedByManageType.entrySet().stream().map(entry -> this.manage.providersByIdIn((EntityType)entry.getKey(), ((List)entry.getValue()).stream().map(Application::getManageId).collect(Collectors.toList()))).flatMap(Collection::stream).toList();
        Map<String, Long> applicationsPerManageId = this.applicationRepository.countByApplications().stream().collect(Collectors.toMap(m -> (String)m.get("manage_id"), m -> (Long)m.get("role_count")));
        providers.forEach(provider -> {
            Long roleCount = applicationsPerManageId.getOrDefault(provider.get("id"), 0L);
            provider.put("roleCount", roleCount);
        });
        List provisionings = this.manage.provisioning(applications.stream().map(Application::getManageId).toList());
        return ResponseEntity.ok(Map.of("providers", providers, "provisionings", provisionings));
    }

    @GetMapping(value={"/provisionings/{id}"})
    public ResponseEntity<Boolean> provisionings(@PathVariable(value="id") String id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /manage/provisionings for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertInstitutionAdmin((User)user);
        List provisionings = this.manage.provisioning(List.of(id));
        return ResponseEntity.ok((Object)(!provisionings.isEmpty() ? 1 : 0));
    }
}

