/*
 * Decompiled with CFR 0.152.
 */
package invite.manage;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class ResilientErrorHandler
implements ResponseErrorHandler {
    private static final Log LOG = LogFactory.getLog(ResilientErrorHandler.class);

    public boolean hasError(ClientHttpResponse response) throws IOException {
        HttpStatusCode statusCode = response.getStatusCode();
        return statusCode.isError();
    }

    public void handleError(URI url, HttpMethod method, ClientHttpResponse response) throws IOException {
        LOG.warn((Object)String.format("Error from Manage: %s, %s, %s, %s", url, method, response.getStatusText(), new String(response.getBody().readAllBytes())));
    }
}

