/*
 * Decompiled with CFR 0.152.
 */
package invite.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;

@Embeddable
public class Auditable
implements Serializable {
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Instant updatedAt;
    @Column(name="updated_by")
    private String updatedBy;

    @PrePersist
    public void prePersist() {
        this.createdAt = Instant.now();
        this.createdBy = this.currentUser();
    }

    @PreUpdate
    public void preUpdate() {
        this.updatedAt = Instant.now();
        this.updatedBy = this.currentUser();
    }

    @JsonIgnore
    private String currentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Map<String, String> attributes = Map.of("eduperson_principal_name", "ResourceCleaner");
        if (authentication instanceof BearerTokenAuthentication) {
            BearerTokenAuthentication bearerTokenAuthentication = (BearerTokenAuthentication)authentication;
            attributes = bearerTokenAuthentication.getTokenAttributes();
        } else if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken authenticationToken = (OAuth2AuthenticationToken)authentication;
            attributes = authenticationToken.getPrincipal().getAttributes();
        } else if (authentication instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = (UsernamePasswordAuthenticationToken)authentication;
            attributes = Map.of("eduperson_principal_name", usernamePasswordAuthenticationToken.getName());
        }
        return attributes.getOrDefault("eduperson_principal_name", "ResourceCleaner").toString();
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }
}

