/*
 * Decompiled with CFR 0.152.
 */
package invite.config;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class HashGenerator {
    private static final Random secureRandom = new SecureRandom();
    public static final DigestUtils digestUtils = new DigestUtils("SHA3-256");

    private HashGenerator() {
    }

    public static String generateRandomHash() {
        byte[] aesKey = new byte[128];
        secureRandom.nextBytes(aesKey);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(aesKey);
    }

    public static String generateToken() {
        RandomStringUtils.secure();
        return RandomStringUtils.random((int)36, (boolean)true, (boolean)true);
    }

    public static String hashToken(String token) {
        return digestUtils.digestAsHex(token);
    }
}

