/*
 * Decompiled with CFR 0.152.
 */
package invite.security;

import invite.model.Application;
import invite.model.Provisionable;
import invite.security.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;

public class RemoteUser
implements UserDetails,
CredentialsContainer,
Provisionable {
    private String username;
    private String password;
    private String displayName;
    private List<Scope> scopes = new ArrayList();
    private List<Application> applications = new ArrayList();
    private boolean localDevMode;

    public RemoteUser(RemoteUser remoteUser) {
        this.username = remoteUser.username;
        this.password = remoteUser.password;
        this.displayName = remoteUser.displayName;
        this.scopes = remoteUser.scopes;
        this.applications = remoteUser.applications;
        this.localDevMode = remoteUser.localDevMode;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.scopes.stream().map(scope -> new SimpleGrantedAuthority("ROLE_" + scope.name().toUpperCase())).collect(Collectors.toList());
    }

    public String getName() {
        return StringUtils.hasText((String)this.displayName) ? this.displayName : this.username;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public List<Scope> getScopes() {
        return this.scopes;
    }

    @Generated
    public List<Application> getApplications() {
        return this.applications;
    }

    @Generated
    public boolean isLocalDevMode() {
        return this.localDevMode;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    @Generated
    public void setApplications(List<Application> applications) {
        this.applications = applications;
    }

    @Generated
    public void setLocalDevMode(boolean localDevMode) {
        this.localDevMode = localDevMode;
    }

    @Generated
    public RemoteUser() {
    }

    @Generated
    public RemoteUser(String username, String password, String displayName, List<Scope> scopes, List<Application> applications, boolean localDevMode) {
        this.username = username;
        this.password = password;
        this.displayName = displayName;
        this.scopes = scopes;
        this.applications = applications;
        this.localDevMode = localDevMode;
    }
}

