/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.api.ApplicationResource;
import invite.api.FullSearchQueryParser;
import invite.api.Pagination;
import invite.api.Results;
import invite.api.RoleOperations;
import invite.config.Config;
import invite.exception.NotFoundException;
import invite.exception.UserRestrictionException;
import invite.logging.AccessLogger;
import invite.logging.Event;
import invite.manage.EntityType;
import invite.manage.Manage;
import invite.model.Application;
import invite.model.ApplicationUsage;
import invite.model.Authority;
import invite.model.Provisionable;
import invite.model.Role;
import invite.model.RoleRequest;
import invite.model.User;
import invite.model.UserRole;
import invite.provision.ProvisioningService;
import invite.provision.scim.GroupURN;
import invite.repository.ApplicationRepository;
import invite.repository.ApplicationUsageRepository;
import invite.repository.RoleRepository;
import invite.repository.UserRoleRepository;
import invite.security.UserPermissions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.sql.SQLTransactionRollbackException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/roles", "/api/external/v1/roles"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class RoleController
implements ApplicationResource {
    private static final Log LOG = LogFactory.getLog(RoleController.class);
    private final RoleRepository roleRepository;
    private final UserRoleRepository userRoleRepository;
    private final ApplicationRepository applicationRepository;
    private final ApplicationUsageRepository applicationUsageRepository;
    private final Manage manage;
    private final ProvisioningService provisioningService;
    private final RoleOperations roleOperations;
    private final String groupUrnPrefix;

    public RoleController(RoleRepository roleRepository, UserRoleRepository userRoleRepository, ApplicationRepository applicationRepository, ApplicationUsageRepository applicationUsageRepository, Manage manage, ProvisioningService provisioningService, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix) {
        this.roleRepository = roleRepository;
        this.userRoleRepository = userRoleRepository;
        this.applicationRepository = applicationRepository;
        this.applicationUsageRepository = applicationUsageRepository;
        this.manage = manage;
        this.provisioningService = provisioningService;
        this.roleOperations = new RoleOperations((ApplicationResource)this);
        this.groupUrnPrefix = groupUrnPrefix;
    }

    @GetMapping(value={""})
    @Transactional(readOnly=true)
    public ResponseEntity<Page<Role>> rolesByApplication(@Parameter(hidden=true) User user, @RequestParam(value="force", required=false, defaultValue="true") boolean force, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection) {
        Page rolesPage;
        LOG.debug((Object)String.format("/roles for user %s", user.getEduPersonPrincipalName()));
        if (user.isSuperUser()) {
            if (force) {
                pageable = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
                rolesPage = this.roleRepository.searchByPage((Pageable)pageable);
            } else {
                pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
                boolean queryHasText = StringUtils.hasText((String)query);
                query = queryHasText ? URLDecoder.decode((String)query, Charset.defaultCharset()) : query;
                String parsedQuery = queryHasText ? FullSearchQueryParser.parse((String)query) : "";
                boolean noSearchTokens = parsedQuery.equals("*");
                if (queryHasText && !noSearchTokens) {
                    rolesPage = this.roleRepository.searchByPageWithKeyword(parsedQuery, (Pageable)pageable);
                } else if (noSearchTokens) {
                    query = ((String)query).toUpperCase() + "%";
                    rolesPage = this.roleRepository.searchByPageWithStrictSearch((String)query, (Pageable)pageable);
                } else {
                    rolesPage = this.roleRepository.searchByPage((Pageable)pageable);
                }
            }
        } else {
            UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
            pageable = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
            rolesPage = this.roleRepository.searchByPageAndOrganizationGUID(user.getOrganizationGUID(), (Pageable)pageable);
        }
        List<Long> roleIdentifiers = rolesPage.getContent().stream().map(role -> role.getId()).toList();
        List applications = this.roleRepository.findApplications(roleIdentifiers);
        List roles = this.manage.addManageMetaData(this.roleFromQuery(rolesPage, applications));
        return Pagination.of((Page)rolesPage, (List)roles);
    }

    @GetMapping(value={"{id}"})
    @Transactional(readOnly=true)
    public ResponseEntity<Role> role(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/role/%s for user %s", id, user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        this.manage.addManageMetaData(List.of(role));
        return ResponseEntity.ok((Object)role);
    }

    @GetMapping(value={"/application/{manageId}"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Role>> rolesPerApplicationId(@PathVariable(value="manageId") String manageId, @Parameter(hidden=true) User user) {
        List roles;
        LOG.debug((Object)String.format("/rolesPerApplicationId for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
        if (user.isSuperUser()) {
            roles = this.roleRepository.findByApplicationUsagesApplicationManageId(manageId);
        } else {
            Set applicationManageIdentifiers = user.getApplications().stream().map(m -> (String)m.get("id")).collect(Collectors.toSet());
            Set roleManageIdentifiers = user.getUserRoles().stream().filter(userRole -> userRole.getAuthority().hasEqualOrHigherRights(Authority.MANAGER)).map(userRole -> userRole.getRole().applicationsUsed()).flatMap(Collection::stream).map(Application::getManageId).collect(Collectors.toSet());
            applicationManageIdentifiers.addAll(roleManageIdentifiers);
            if (!applicationManageIdentifiers.contains(manageId)) {
                throw new UserRestrictionException();
            }
            roles = this.roleRepository.findByOrganizationGUIDAndApplicationUsagesApplicationManageId(user.getOrganizationGUID(), manageId);
        }
        return ResponseEntity.ok((Object)this.manage.addManageMetaData(roles));
    }

    @PostMapping(value={""})
    public ResponseEntity<Role> newRole(@Validated @RequestBody RoleRequest roleRequest, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("POST /roles/ for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
        if (user.isSuperUser() && !StringUtils.hasText((String)roleRequest.getOrganizationGUID())) {
            throw new UserRestrictionException();
        }
        Role role = new Role(roleRequest);
        role.setOrganizationGUID(user.isSuperUser() ? roleRequest.getOrganizationGUID() : user.getOrganizationGUID());
        role.setShortName(GroupURN.sanitizeRoleShortName((String)roleRequest.getName()));
        role.setIdentifier(UUID.randomUUID().toString());
        role.setUrn(GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role));
        LOG.debug((Object)String.format("New role '%s' by user %s", role.getName(), user.getName()));
        return this.saveOrUpdate(role, user);
    }

    @PutMapping(value={""})
    @Retryable(retryFor={SQLTransactionRollbackException.class}, maxAttempts=3, backoff=@Backoff(delay=1000L))
    public ResponseEntity<Role> updateRole(@Validated @RequestBody Role role, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("PUT /roles/ for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.MANAGER);
        LOG.debug((Object)String.format("Update role '%s' by user %s", role.getName(), user.getEduPersonPrincipalName()));
        return this.saveOrUpdate(role, user);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteRole(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Role not found"));
        List userRoles = this.userRoleRepository.findByRole(role);
        if (!userRoles.isEmpty() && !user.isSuperUser()) {
            throw new UserRestrictionException(String.format("User %s is not allowed to delete role %s when there are still %s userRoles", user.getEmail(), role.getName(), userRoles.size()));
        }
        LOG.debug((Object)String.format("Delete role %s by user %s", role.getName(), user.getEduPersonPrincipalName()));
        this.manage.addManageMetaData(List.of(role));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INSTITUTION_ADMIN);
        if (!user.isSuperUser() && !Objects.equals(user.getOrganizationGUID(), role.getOrganizationGUID())) {
            throw new UserRestrictionException();
        }
        this.provisioningService.deleteGroupRequest(role);
        this.provisioningService.deleteUserRequest(role);
        this.roleRepository.deleteRoleById(role.getId());
        AccessLogger.role((Log)LOG, (Event)Event.Deleted, (Provisionable)user, (Role)role);
        return Results.deleteResult();
    }

    private ResponseEntity<Role> saveOrUpdate(Role role, User user) {
        this.roleOperations.assertValidRole(role);
        this.roleOperations.setDefaultsValidRole(role);
        this.manage.addManageMetaData(List.of(role));
        boolean isNew = role.getId() == null;
        ArrayList previousApplicationIdentifiers = new ArrayList();
        Optional optionalUserRole = user.userRoleForRole(role);
        boolean immutableApplicationUsages = !user.isSuperUser() && optionalUserRole.isPresent() && ((UserRole)optionalUserRole.get()).getAuthority().equals((Object)Authority.MANAGER);
        boolean nameChanged = false;
        if (!isNew) {
            Role previousRole = (Role)this.roleRepository.findById((Object)role.getId()).orElseThrow(() -> new NotFoundException("Role not found"));
            role.setShortName(previousRole.getShortName());
            role.setIdentifier(previousRole.getIdentifier());
            if (user.isSuperUser()) {
                role.setOrganizationGUID(role.getOrganizationGUID());
            } else {
                role.setOrganizationGUID(previousRole.getOrganizationGUID());
            }
            previousApplicationIdentifiers.addAll(previousRole.applicationIdentifiers());
            if (immutableApplicationUsages) {
                role.setApplicationUsages(previousRole.getApplicationUsages());
            }
            boolean bl = nameChanged = !previousRole.getName().equals(role.getName());
        }
        if (!immutableApplicationUsages) {
            this.roleOperations.syncRoleApplicationUsages(role);
        }
        Role saved = (Role)this.roleRepository.save((Object)role);
        if (isNew) {
            this.provisioningService.newGroupRequest(saved);
        } else {
            this.provisioningService.updateGroupRequest(previousApplicationIdentifiers, saved, nameChanged);
        }
        AccessLogger.role((Log)LOG, (Event)(isNew ? Event.Created : Event.Updated), (Provisionable)user, (Role)role);
        return ResponseEntity.ok((Object)saved);
    }

    private List<Role> roleFromQuery(Page<Role> rolesPage, List<Map<String, Object>> applications) {
        List roles = rolesPage.getContent();
        Map<Long, List<Map>> applicationGroupedByRoleId = applications.stream().collect(Collectors.groupingBy(m -> (Long)m.get("role_id")));
        roles.forEach(role -> {
            List applicationsForRole = (List)applicationGroupedByRoleId.get(role.getId());
            if (applicationsForRole != null) {
                Set applicationUsages = applicationsForRole.stream().map(m -> new ApplicationUsage(new Application((String)m.get("manage_id"), EntityType.valueOf((String)((String)m.get("manage_type")))), null)).collect(Collectors.toSet());
                role.setApplicationUsages(applicationUsages);
            }
        });
        return roles;
    }

    @Generated
    public ApplicationRepository getApplicationRepository() {
        return this.applicationRepository;
    }

    @Generated
    public ApplicationUsageRepository getApplicationUsageRepository() {
        return this.applicationUsageRepository;
    }
}

