/*
 * Decompiled with CFR 0.152.
 */
package invite.crm;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import invite.api.InvitationOperations;
import invite.audit.UserRoleAuditService;
import invite.config.HashGenerator;
import invite.crm.CRMContact;
import invite.crm.CRMOrganisation;
import invite.crm.CRMRole;
import invite.crm.CrmConfigEntry;
import invite.crm.CrmManageIdentifier;
import invite.exception.InvalidInputException;
import invite.exception.NotFoundException;
import invite.mail.MailBox;
import invite.manage.EntityType;
import invite.manage.Manage;
import invite.model.Application;
import invite.model.ApplicationUsage;
import invite.model.Authority;
import invite.model.Invitation;
import invite.model.InvitationRole;
import invite.model.Language;
import invite.model.Provisionable;
import invite.model.Role;
import invite.model.User;
import invite.model.UserRole;
import invite.model.UserRoleAudit;
import invite.provision.ProvisioningService;
import invite.provision.scim.OperationType;
import invite.repository.ApplicationRepository;
import invite.repository.RoleRepository;
import invite.repository.UserRepository;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/internal/v1/crm"}, produces={"application/json"})
@Transactional
public class CRMController {
    private static final Log LOG = LogFactory.getLog(CRMController.class);
    private final String collabPersonPrefix;
    private final UserRepository userRepository;
    private final RoleRepository roleRepository;
    private final ApplicationRepository applicationRepository;
    private final ProvisioningService provisioningService;
    private final MailBox mailBox;
    private final Manage manage;
    private final Map<String, CrmConfigEntry> crmConfig;
    private final UserRoleAuditService userRoleAuditService;
    private final Provisionable provisionable = () -> "SURF CRM";

    public CRMController(@Value(value="${crm.collab-person-prefix}") String collabPersonPrefix, @Value(value="${crm.crm-config-resource}") Resource crmConfigResource, UserRepository userRepository, RoleRepository roleRepository, ApplicationRepository applicationRepository, ProvisioningService provisioningService, ObjectMapper objectMapper, MailBox mailBox, Manage manage, UserRoleAuditService userRoleAuditService) throws IOException {
        this.userRepository = userRepository;
        this.collabPersonPrefix = collabPersonPrefix;
        this.roleRepository = roleRepository;
        this.applicationRepository = applicationRepository;
        this.provisioningService = provisioningService;
        this.mailBox = mailBox;
        this.manage = manage;
        this.userRoleAuditService = userRoleAuditService;
        Map crmConfigRaw = (Map)objectMapper.readValue(crmConfigResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.crmConfig = crmConfigRaw.entrySet().stream().map(entry -> new CrmConfigEntry((String)entry.getKey(), (String)((Map)entry.getValue()).get("name"), ((List)((Map)entry.getValue()).get("applications")).stream().map(application -> new CrmManageIdentifier(EntityType.valueOf((String)((String)application.get("manageType")).toUpperCase()), (String)application.get("manageEntityID"))).toList())).collect(Collectors.toMap(crmConfigEntry -> crmConfigEntry.code(), crmConfigEntry -> crmConfigEntry));
    }

    @PostMapping(value={""})
    public ResponseEntity<String> contact(@RequestBody CRMContact crmContact) {
        boolean created;
        LOG.debug((Object)("POST /api/external/v1/crm: " + String.valueOf(crmContact)));
        if (crmContact.isSuppressInvitation()) {
            if (!StringUtils.hasText((String)crmContact.getSchacHomeOrganisation()) || !StringUtils.hasText((String)crmContact.getUid())) {
                throw new InvalidInputException("Missing schacHomeOrganisation or uid in crmContact with sendInvitation false: " + String.valueOf(crmContact));
            }
            created = this.provisionUser(crmContact);
        } else {
            created = this.sendInvitation(crmContact);
        }
        return ResponseEntity.ok().body((Object)(created ? "created" : "updated"));
    }

    @DeleteMapping(value={""})
    public ResponseEntity<String> delete(@RequestBody CRMContact crmContact) {
        LOG.debug((Object)("DELETE /api/external/v1/crm: " + String.valueOf(crmContact)));
        List users = this.userRepository.findByCrmContactId(crmContact.getContactId());
        users.forEach(user -> {
            LOG.info((Object)("Deleting CRM user: " + user.getEmail()));
            this.provisioningService.deleteUserRequest(user);
            this.userRepository.delete(user);
        });
        return ResponseEntity.ok().body((Object)"deleted");
    }

    private boolean provisionUser(CRMContact crmContact) {
        String sub = this.constructSub(crmContact);
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        User user = optionalUser.orElseGet(() -> this.createUser(crmContact, sub));
        List newCrmRoles = this.syncCrmRoles(crmContact, user);
        List roles = this.convertCrmRolesToInviteRoles(crmContact, newCrmRoles);
        roles.forEach(role -> {
            UserRole userRole = new UserRole(Authority.GUEST, role);
            user.addUserRole(userRole);
            this.userRoleAuditService.logAction(userRole, UserRoleAudit.ActionType.ADD);
            this.provisioningService.updateGroupRequest(userRole, OperationType.add);
        });
        this.userRepository.save((Object)user);
        return optionalUser.isEmpty();
    }

    private User createUser(CRMContact crmContact, String sub) {
        String middleName = crmContact.getMiddlename();
        String surName = crmContact.getSurname();
        User unsavedUser = new User(false, crmContact.getEmail(), sub, crmContact.getSchacHomeOrganisation(), crmContact.getFirstname(), StringUtils.hasText((String)middleName) ? String.format("%s %s", middleName, surName) : surName, crmContact.getEmail());
        unsavedUser.setCrmContactId(crmContact.getContactId());
        User user = (User)this.userRepository.save((Object)unsavedUser);
        this.provisioningService.newUserRequest(user);
        return user;
    }

    private String constructSub(CRMContact crmContact) {
        return String.format("%s:%s:%s", this.collabPersonPrefix, crmContact.getSchacHomeOrganisation(), crmContact.getUid());
    }

    private List<CRMRole> syncCrmRoles(CRMContact crmContact, User user) {
        user.getUserRoles().removeIf(userRole -> {
            boolean isDeleted;
            Role role = userRole.getRole();
            boolean bl = isDeleted = StringUtils.hasText((String)role.getCrmRoleId()) && crmContact.getRoles().stream().noneMatch(crmRole -> crmRole.getRoleId().equals(role.getCrmRoleId()));
            if (isDeleted) {
                this.provisioningService.updateGroupRequest(userRole, OperationType.remove);
            }
            return isDeleted;
        });
        List<Role> currentRoles = user.getUserRoles().stream().map(userRole -> userRole.getRole()).toList();
        return crmContact.getRoles().stream().filter(crmRole -> currentRoles.stream().noneMatch(role -> crmRole.getRoleId().equalsIgnoreCase(role.getCrmRoleId()))).toList();
    }

    private boolean sendInvitation(CRMContact crmContact) {
        String sub = this.constructSub(crmContact);
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        List newCrmRoles = this.syncCrmRoles(crmContact, optionalUser.orElse(new User()));
        optionalUser.ifPresent(user -> this.userRepository.save(user));
        if (!CollectionUtils.isEmpty((Collection)newCrmRoles)) {
            List roles = this.convertCrmRolesToInviteRoles(crmContact, newCrmRoles);
            List groupedProviders = this.manage.getGroupedProviders(roles);
            Set invitationRoles = roles.stream().map(role -> new InvitationRole(role)).collect(Collectors.toSet());
            Invitation invitation = this.createInvitation(crmContact, invitationRoles);
            invitation.setOrganizationGUID(crmContact.getOrganisation().getOrganisationId());
            Optional idpName = InvitationOperations.identityProviderName((Manage)this.manage, (Invitation)invitation);
            this.mailBox.sendInviteMail(this.provisionable, invitation, groupedProviders, Language.en, idpName);
        }
        return optionalUser.isEmpty();
    }

    private @NonNull List<Role> convertCrmRolesToInviteRoles(CRMContact crmContact, List<CRMRole> newCrmRoles) {
        return newCrmRoles.stream().map(crmRole -> this.roleRepository.findByCrmRoleId(crmRole.getRoleId()).orElseGet(() -> this.createRole(crmContact.getOrganisation(), crmRole))).toList();
    }

    private Role createRole(CRMOrganisation crmOrganisation, CRMRole crmRole) {
        CrmConfigEntry crmConfigEntry = (CrmConfigEntry)this.crmConfig.get(crmRole.getSabCode());
        if (crmConfigEntry == null) {
            throw new InvalidInputException("CRM sabCode is not configured: " + crmRole.getSabCode());
        }
        Set applicationUsages = crmConfigEntry.crmManageIdentifiers().stream().map(crmManageIdentifier -> (Map)this.manage.providerByEntityID(crmManageIdentifier.manageType(), crmManageIdentifier.manageEntityID()).orElseThrow(() -> new NotFoundException("Manage entity not found: " + String.valueOf(crmManageIdentifier)))).map(provider -> {
            String manageId = (String)provider.get("id");
            EntityType manageType = EntityType.valueOf((String)((String)provider.get("type")).toUpperCase());
            return this.applicationRepository.findByManageIdAndManageTypeOrderById(manageId, manageType).orElseGet(() -> (Application)this.applicationRepository.save((Object)new Application(manageId, manageType, (String)provider.get("url"))));
        }).map(application -> new ApplicationUsage(application, application.getLandingPage())).collect(Collectors.toSet());
        Role unsavedRole = new Role(String.format("%s for %s", crmConfigEntry.name(), crmOrganisation.getName()), String.format("CRM role %s for organisation %s", crmConfigEntry.name(), crmOrganisation.getName()), applicationUsages, Integer.valueOf(365), true, false);
        unsavedRole.setCrmRoleId(crmRole.getRoleId());
        unsavedRole.setCrmRoleName(crmConfigEntry.name());
        unsavedRole.setCrmOrganisationId(crmOrganisation.getOrganisationId());
        unsavedRole.setCrmOrganisationCode(crmOrganisation.getAbbrev());
        Role role = (Role)this.roleRepository.save((Object)unsavedRole);
        this.provisioningService.newGroupRequest(role);
        return role;
    }

    private Invitation createInvitation(CRMContact crmContact, Set<InvitationRole> invitationRoles) {
        return new Invitation(Authority.GUEST, HashGenerator.generateRandomHash(), crmContact.getEmail(), true, false, null, false, null, Language.en, null, null, null, invitationRoles, null);
    }
}

