/*
 * Decompiled with CFR 0.152.
 */
package invite.repository;

import invite.model.User;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, Long>,
QueryRewriter {
    public Optional<User> findBySubIgnoreCase(String var1);

    public List<User> findByCrmContactId(String var1);

    public List<User> findByOrganizationGUIDAndInstitutionAdmin(String var1, boolean var2);

    public List<User> findBySuperUserTrue();

    public long countBySuperUserTrue();

    public long countByInstitutionAdminTrue();

    public Optional<User> findByEduPersonPrincipalNameIgnoreCase(String var1);

    public Optional<User> findByEmailIgnoreCase(String var1);

    public List<User> findByLastActivityBefore(Instant var1);

    @Query(value=" SELECT u.id, u.name, u.email, u.schac_home_organization, u.super_user, u.institution_admin,\n    u.created_at as createdAt, u.last_activity as lastActivity,\n    (SELECT GROUP_CONCAT(DISTINCT ur.authority) FROM user_roles ur WHERE ur.user_id = u.id) AS authority\n    FROM users u\n", countQuery="SELECT count(*) FROM users", queryRewriter=UserRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPage(Pageable var1);

    @Query(value=" SELECT u.id, u.name, u.email, u.schac_home_organization, u.super_user, u.institution_admin,\n    u.created_at as createdAt, u.last_activity as lastActivity,\n(SELECT GROUP_CONCAT(DISTINCT ur.authority) FROM user_roles ur WHERE ur.user_id = u.id) AS authority\n  FROM users u WHERE MATCH (given_name, family_name, email, schac_home_organization) against (?1  IN BOOLEAN MODE)\n", countQuery="SELECT count(*) FROM users WHERE MATCH (given_name, family_name, email, schac_home_organization) against (?1  IN BOOLEAN MODE)", queryRewriter=UserRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPageWithKeyword(String var1, Pageable var2);

    @Query(value=" SELECT u.id, u.name, u.email, u.schac_home_organization, u.super_user, u.institution_admin,\n    u.created_at as createdAt, u.last_activity as lastActivity,\n(SELECT GROUP_CONCAT(DISTINCT ur.authority) FROM user_roles ur WHERE ur.user_id = u.id) AS authority\n  FROM users u WHERE\n           UPPER(u.email) LIKE ?1 or UPPER(u.schac_home_organization) LIKE ?1\n", countQuery="SELECT count(*) FROM users WHERE UPPER(u.email) LIKE ?1 or UPPER(u.schac_home_organization) LIKE ?1", queryRewriter=UserRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPageWithStrictMode(String var1, Pageable var2);

    @Query(value="SELECT distinct(u.id), u.email, u.name, u.schac_home_organization, u.created_at, u.last_activity\nFROM users u\nINNER JOIN user_roles ur ON ur.user_id = u.id\nINNER JOIN roles r ON r.id = ur.role_id\nWHERE r.organization_guid = ?1\n", queryRewriter=UserRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPageRoleUsers(String var1, Pageable var2);

    @Query(value="SELECT distinct(u.id), u.email, u.name, u.schac_home_organization, u.created_at, u.last_activity\nFROM users u\nINNER JOIN user_roles ur ON ur.user_id = u.id\nINNER JOIN roles r ON r.id = ur.role_id\nWHERE r.organization_guid = ?1 AND\nMATCH (given_name, family_name, email, schac_home_organization) against (?2  IN BOOLEAN MODE)\n", queryRewriter=UserRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPageRoleUsersWithKeyWord(String var1, String var2, Pageable var3);

    @Query(value="SELECT distinct(u.id), u.email, u.name, u.schac_home_organization, u.created_at, u.last_activity\nFROM users u\nINNER JOIN user_roles ur ON ur.user_id = u.id\nINNER JOIN roles r ON r.id = ur.role_id\nWHERE r.organization_guid = ?1 AND\n(UPPER(u.email) LIKE ?2 or UPPER(u.schac_home_organization) LIKE ?2)\n", queryRewriter=UserRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByPageRoleUsersWithStrictSearch(String var1, String var2, Pageable var3);

    @Query(value="SELECT ur.user_id, ur.authority, ur.end_date, r.name, r.id\nFROM user_roles ur INNER JOIN roles r ON r.id = ur.role_id\nWHERE ur.user_id in ?1\n", nativeQuery=true)
    public List<Map<String, Object>> findUserRoles(List<Long> var1);

    @Query(value="SELECT * FROM users u WHERE super_user = 0 AND institution_admin = 0 AND NOT EXISTS (SELECT ur.id FROM user_roles ur WHERE ur.user_id = u.id)", nativeQuery=true)
    public List<User> findNonSuperUserWithoutUserRoles();

    default public String rewrite(String query, Sort sort) {
        Sort.Order authoritySort = sort.getOrderFor("authority");
        if (authoritySort != null) {
            return query.replace("order by u.authority", "order by authority");
        }
        Sort.Order endDateSort = sort.getOrderFor("endDate");
        if (endDateSort != null) {
            query = query.replace("distinct(u.id)", "u.id");
            return query.replace("order by u.endDate", "order by ur.end_date");
        }
        return query;
    }
}

