/*
 * Decompiled with CFR 0.152.
 */
package invite.cron;

import invite.audit.UserRoleAuditService;
import invite.cron.AbstractNodeLeader;
import invite.model.Role;
import invite.model.User;
import invite.model.UserRole;
import invite.model.UserRoleAudit;
import invite.provision.ProvisioningService;
import invite.repository.UserRepository;
import invite.repository.UserRoleRepository;
import java.io.Serializable;
import java.time.Instant;
import java.time.Period;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ResourceCleaner
extends AbstractNodeLeader {
    public static final String LOCK_NAME = "resource_cleaner_user_level_lock";
    private static final Log LOG = LogFactory.getLog(ResourceCleaner.class);
    private final UserRepository userRepository;
    private final ProvisioningService provisioningService;
    private final UserRoleRepository userRoleRepository;
    private final UserRoleAuditService userRoleAuditService;
    private final int lastActivityDurationDays;

    @Autowired
    public ResourceCleaner(UserRepository userRepository, UserRoleRepository userRoleRepository, ProvisioningService provisioningService, DataSource dataSource, UserRoleAuditService userRoleAuditService, @Value(value="${cron.last-activity-duration-days}") int lastActivityDurationDays) {
        super(LOCK_NAME, dataSource);
        this.userRepository = userRepository;
        this.userRoleRepository = userRoleRepository;
        this.userRoleAuditService = userRoleAuditService;
        this.lastActivityDurationDays = lastActivityDurationDays;
        this.provisioningService = provisioningService;
    }

    @Scheduled(cron="${cron.user-cleaner-expression}")
    @Transactional
    public void clean() {
        super.perform("ResourceCleaner#clean", () -> this.doClean());
    }

    public Map<String, List<? extends Serializable>> doClean() {
        List users = this.cleanNonActiveUsers();
        List orphans = this.cleanOrphanedUser();
        List userRoles = this.cleanUserRoles();
        return Map.of("DeletedNonActiveUsers", users, "DeletedOrphanUsers", orphans, "DeletedExpiredUserRoles", userRoles);
    }

    private List<User> cleanNonActiveUsers() {
        Instant past = Instant.now().minus(Period.ofDays(this.lastActivityDurationDays));
        List users = this.userRepository.findByLastActivityBefore(past);
        this.doDeleteUsers(users, "Deleted user %s with no recent activity");
        return users;
    }

    private List<User> cleanOrphanedUser() {
        List orphans = this.userRepository.findNonSuperUserWithoutUserRoles();
        this.doDeleteUsers(orphans, "Deleted non-super user %s with no roles");
        return orphans;
    }

    private void doDeleteUsers(List<User> users, String logMessage) {
        users.forEach(user -> {
            try {
                this.provisioningService.deleteUserRequest(user);
                this.userRepository.delete(user);
                LOG.info((Object)String.format(logMessage, user.getEmail()));
            }
            catch (RuntimeException e) {
                LOG.error((Object)String.format("Error in provisioningService#deleteUserRequest for user %s", user.getEmail()), (Throwable)e);
            }
        });
    }

    private List<UserRole> cleanUserRoles() {
        List userRoles = this.userRoleRepository.findByEndDateBeforeAndExpiryNotifications(Instant.now(), Integer.valueOf(1));
        userRoles.forEach(userRole -> {
            User user = userRole.getUser();
            Role role = userRole.getRole();
            try {
                this.userRoleAuditService.logAction(userRole, UserRoleAudit.ActionType.DELETE);
                this.provisioningService.deleteUserRoleRequest(userRole);
                this.userRoleRepository.deleteUserRoleById(userRole.getId());
                LOG.info((Object)String.format("Deleted userRole for user %s and role %s with an endDate in the past", user.getEmail(), role.getName()));
            }
            catch (RuntimeException e) {
                LOG.error((Object)String.format("Error in provisioningService#updateGroupRequest for user %s and userRole %s", user.getEmail(), role.getName()), (Throwable)e);
            }
        });
        return userRoles;
    }
}

