/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.api.FullSearchQueryParser;
import invite.api.InvitationOperations;
import invite.api.InvitationResource;
import invite.api.Pagination;
import invite.api.Results;
import invite.audit.UserRoleAuditService;
import invite.exception.InvitationEmailMatchingException;
import invite.exception.InvitationExpiredException;
import invite.exception.InvitationStatusException;
import invite.exception.InvitationUniqueCrmOrganisationException;
import invite.exception.NotFoundException;
import invite.logging.AccessLogger;
import invite.logging.Event;
import invite.mail.MailBox;
import invite.manage.Manage;
import invite.model.AcceptInvitation;
import invite.model.Authority;
import invite.model.Invitation;
import invite.model.InvitationRequest;
import invite.model.InvitationResponse;
import invite.model.InvitationRole;
import invite.model.Role;
import invite.model.Status;
import invite.model.StatusResponse;
import invite.model.User;
import invite.model.UserRole;
import invite.model.UserRoleAudit;
import invite.provision.Provisioning;
import invite.provision.ProvisioningService;
import invite.provision.scim.OperationType;
import invite.repository.InvitationRepository;
import invite.repository.RoleRepository;
import invite.repository.UserRepository;
import invite.security.SuperAdmin;
import invite.security.UserPermissions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invitations", "/api/external/v1/invitations"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={SuperAdmin.class})
public class InvitationController
implements InvitationResource {
    private static final Log LOG = LogFactory.getLog(InvitationController.class);
    private final MailBox mailBox;
    private final Manage manage;
    private final InvitationRepository invitationRepository;
    private final RoleRepository roleRepository;
    private final UserRepository userRepository;
    private final ProvisioningService provisioningService;
    private final SecurityContextRepository securityContextRepository;
    private final SuperAdmin superAdmin;
    private final InvitationOperations invitationOperations;
    private final UserRoleAuditService userRoleAuditService;

    public InvitationController(MailBox mailBox, Manage manage, InvitationRepository invitationRepository, UserRepository userRepository, RoleRepository roleRepository, ProvisioningService provisioningService, SecurityContextRepository securityContextRepository, SuperAdmin superAdmin, UserRoleAuditService userRoleAuditService) {
        this.mailBox = mailBox;
        this.manage = manage;
        this.invitationRepository = invitationRepository;
        this.userRepository = userRepository;
        this.roleRepository = roleRepository;
        this.provisioningService = provisioningService;
        this.securityContextRepository = securityContextRepository;
        this.superAdmin = superAdmin;
        this.invitationOperations = new InvitationOperations((InvitationResource)this);
        this.userRoleAuditService = userRoleAuditService;
    }

    @PostMapping(value={""})
    @Operation(summary="Invite member for existing Role", description="Invite a member for an existing role. An invitation email will be sent. Do not forget to set guestRoleIncluded to true.\nAt least one email must be either present in invites or invitesWithInternalPlaceholderIdentifiers.\nWhen using the invitations you can also specify the\ninternalPlaceholderIdentifier, which will be used as the id in the SCIM POST to /User.\n", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=InvitationRequest.class), examples={@ExampleObject(value="{\n  \"intendedAuthority\": \"INVITER\",\n  \"message\": \"Personal message included in the email\",\n  \"language\": \"en\",\n  \"guestRoleIncluded\": true,\n  \"invites\": [\n    \"admin@service.org\"\n  ],\n  \"invitesWithInternalPlaceholderIdentifiers\": [\n    {\n      \"email\": \"admin2@service.org\",\n      \"internalPlaceholderIdentifier\": \"4EFF937F-EE78-4A54-9FD8-A214FD64D7E1\"\n    }\n  ],\n  \"roleIdentifiers\": [\n    99\n  ],\n  \"roleExpiryDate\": 1760788376,\n  \"expiryDate\": 1730461976\n}\n")})}), responses={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=InvitationResponse.class), examples={@ExampleObject(value="{\n  \"status\": 201,\n  \"recipientInvitationURLs\": [\n    {\n      \"recipient\": \"admin@service.nl\",\n      \"invitationURL\": \"https://invite.test.surfconext.nl/invitation/accept?{hash}\"\n    }\n  ]\n}\n")})}), @ApiResponse(responseCode="400", description="BadRequest", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 400,\n  \"error\": \"BadRequest\",\n  \"exception\": \"access.exception.UserRestrictionException\",\n  \"message\": \"No access to application\",\n  \"path\": \"/api/internal/invite/invitations\"\n}\n")})}), @ApiResponse(responseCode="404", description="Role not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\n  \"timestamp\": 1717672263253,\n  \"status\": 404,\n  \"error\": \"Not found\",\n  \"exception\": \"access.exception.NotFoundException\",\n  \"message\": \"Role not found\",\n  \"path\": \"/api/internal/invite/invitations\"\n}\n")})})})
    public ResponseEntity<InvitationResponse> newInvitation(@Validated @RequestBody InvitationRequest invitationRequest, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("New invitation request by user %s", user.getEduPersonPrincipalName()));
        return this.invitationOperations.sendInvitation(invitationRequest, user, null);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteInvitation(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/deleteInvitation/%s by user %s", id, user.getEduPersonPrincipalName()));
        Invitation invitation = (Invitation)this.invitationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Invitation not found"));
        List<Role> requestedRoles = invitation.getRoles().stream().map(InvitationRole::getRole).toList();
        Authority intendedAuthority = invitation.getIntendedAuthority();
        UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        AccessLogger.invitation((Log)LOG, (Event)Event.Deleted, (Invitation)invitation);
        this.invitationRepository.delete((Object)invitation);
        return Results.deleteResult();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Map<String, Integer>> resendInvitation(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("ResendInvitation with id %s by user %s ", id, user.getEduPersonPrincipalName()));
        return this.invitationOperations.resendInvitation(id, user, null);
    }

    @GetMapping(value={"public"})
    @Transactional(readOnly=true)
    public ResponseEntity<Invitation> getInvitation(@RequestParam(value="hash") String hash) {
        LOG.debug((Object)String.format("getInvitation with hash %s", hash));
        Invitation invitation = (Invitation)this.invitationRepository.findByHash(hash).orElseThrow(() -> new NotFoundException("Invitation not found"));
        if (!invitation.getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException("Invitation is not OPEN anymore");
        }
        this.manage.addManageMetaData(invitation.getRoles().stream().map(InvitationRole::getRole).toList());
        return ResponseEntity.ok((Object)invitation);
    }

    @GetMapping(value={"all"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Invitation>> all(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"GET /all invitations");
        UserPermissions.assertAuthority((User)user, (Authority)Authority.SUPER_USER);
        return ResponseEntity.ok((Object)this.invitationRepository.findByStatus(Status.OPEN));
    }

    @PostMapping(value={"accept"})
    public ResponseEntity<Map<String, Object>> accept(@Validated @RequestBody AcceptInvitation acceptInvitation, Authentication authentication, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Optional optionalGraphResponse;
        Invitation invitation = (Invitation)this.invitationRepository.findByHash(acceptInvitation.hash()).orElseThrow(() -> new NotFoundException("Invitation not found"));
        LOG.debug((Object)"POST /accept invitation");
        if (!invitation.getId().equals(acceptInvitation.invitationId())) {
            throw new NotFoundException("Invitation not found");
        }
        if (!invitation.getStatus().equals((Object)Status.OPEN)) {
            throw new InvitationStatusException("Invitation is not OPEN anymore");
        }
        if (invitation.getExpiryDate().isBefore(Instant.now())) {
            throw new InvitationExpiredException("Invitation has expired");
        }
        OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)authentication;
        Map attributes = token.getPrincipal().getAttributes();
        String sub = (String)attributes.get("sub");
        LOG.info((Object)String.format("Accept invitation with id %s by user %s", invitation.getId(), sub));
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        Authority intendedAuthority = invitation.getIntendedAuthority();
        User user = optionalUser.orElseGet(() -> {
            boolean superUser = this.superAdmin.getUsers().stream().anyMatch(superSub -> superSub.equals(sub)) || intendedAuthority.equals((Object)Authority.SUPER_USER);
            return new User(superUser, attributes);
        });
        this.checkEmailEquality(user, invitation);
        this.checkCrmUniqueOrganisation(user, invitation);
        user.setLastActivity(Instant.now());
        invitation.setStatus(Status.ACCEPTED);
        invitation.setAcceptedAt(Instant.now());
        invitation.setSubInvitee(sub);
        this.invitationRepository.save((Object)invitation);
        AccessLogger.invitation((Log)LOG, (Event)Event.Accepted, (Invitation)invitation);
        ArrayList newUserRoles = new ArrayList();
        User inviter = invitation.getInviter();
        invitation.getRoles().forEach(invitationRole -> {
            Role role = invitationRole.getRole();
            Optional<UserRole> optionalUserRole = user.getUserRoles().stream().filter(userRole -> userRole.getRole().getId().equals(role.getId())).findFirst();
            if (optionalUserRole.isPresent()) {
                UserRole userRole2 = optionalUserRole.get();
                Authority currentAuthority = userRole2.getAuthority();
                if (!currentAuthority.equals((Object)intendedAuthority)) {
                    boolean userRoleChanged = false;
                    if (intendedAuthority.hasHigherRights(currentAuthority)) {
                        userRole2.setAuthority(intendedAuthority);
                        userRole2.setEndDate(invitation.getRoleExpiryDate());
                        userRoleChanged = true;
                    }
                    if (currentAuthority.equals((Object)Authority.GUEST) || intendedAuthority.equals((Object)Authority.GUEST) || invitation.isGuestRoleIncluded()) {
                        userRole2.setGuestRoleIncluded(true);
                        userRoleChanged = true;
                    }
                    if (userRoleChanged) {
                        this.userRoleAuditService.logAction(userRole2, UserRoleAudit.ActionType.UPDATE);
                    }
                }
            } else {
                UserRole userRole3 = new UserRole(inviter != null ? inviter.getName() : invitation.getRemoteApiUser(), user, role, intendedAuthority, invitation.isGuestRoleIncluded(), invitation.getRoleExpiryDate());
                user.addUserRole(userRole3);
                newUserRoles.add(userRole3);
            }
        });
        if (intendedAuthority.equals((Object)Authority.INSTITUTION_ADMIN) && inviter != null) {
            user.setInstitutionAdmin(true);
            user.setInstitutionAdminByInvite(true);
            if (inviter.isSuperUser()) {
                user.setOrganizationGUID(invitation.getOrganizationGUID());
            } else {
                user.setOrganizationGUID(inviter.getOrganizationGUID());
            }
            if (optionalUser.isEmpty()) {
                this.saveOAuth2AuthenticationToken(authentication, user, servletRequest, servletResponse);
            }
        }
        user.setInternalPlaceholderIdentifier(invitation.getInternalPlaceholderIdentifier());
        if (StringUtils.hasText((String)invitation.getCrmContactId())) {
            user.setCrmContactId(invitation.getCrmContactId());
            user.setCrmOrganisationId(invitation.getCrmOrganisationId());
        }
        this.userRepository.save((Object)user);
        AccessLogger.user((Log)LOG, (Event)Event.Created, (User)user);
        newUserRoles.forEach(userRole -> this.userRoleAuditService.logAction(userRole, UserRoleAudit.ActionType.ADD));
        boolean isGuest = user.getUserRoles().stream().anyMatch(userRole -> userRole.isGuestRoleIncluded() || userRole.getAuthority().equals((Object)Authority.GUEST));
        Optional optional = optionalGraphResponse = isGuest ? this.provisioningService.newUserRequest(user) : Optional.empty();
        if (isGuest) {
            newUserRoles.forEach(userRole -> this.provisioningService.updateGroupRequest(userRole, OperationType.add));
        }
        LOG.info((Object)String.format("User %s accepted invitation with role(s) %s", user.getEduPersonPrincipalName(), invitation.getRoles().stream().map(role -> role.getRole().getName()).collect(Collectors.joining(", "))));
        HashMap body = new HashMap();
        optionalGraphResponse.ifPresentOrElse(graphResponse -> {
            if (graphResponse.isErrorResponse()) {
                body.put("errorResponse", Boolean.TRUE);
            } else {
                body.put("inviteRedeemUrl", graphResponse.inviteRedeemUrl());
            }
        }, () -> body.put("status", "ok"));
        if (!isGuest) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(body);
        }
        List provisionings = this.provisioningService.getProvisionings(newUserRoles);
        provisionings.stream().filter(provisioning -> provisioning.getUserWaitTime() != null).max(Comparator.comparingInt(Provisioning::getUserWaitTime)).ifPresent(provisioning -> {
            Set manageIdentifiers = provisioning.getRemoteApplications().stream().map(app -> app.manageId()).collect(Collectors.toSet());
            newUserRoles.stream().map(userRole -> userRole.getRole()).filter(role -> role.getApplicationUsages().stream().anyMatch(appUsage -> manageIdentifiers.contains(appUsage.getApplication().getManageId()))).min(Comparator.comparing(Role::getName)).ifPresent(role -> {
                body.put("userWaitTime", provisioning.getUserWaitTime());
                body.put("role", role.getName());
            });
        });
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(body);
    }

    private void saveOAuth2AuthenticationToken(Authentication authentication, User user, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        OAuth2AuthenticationToken existingToken = (OAuth2AuthenticationToken)authentication;
        DefaultOidcUser existingTokenPrincipal = (DefaultOidcUser)existingToken.getPrincipal();
        HashMap claims = new HashMap(existingTokenPrincipal.getClaims());
        claims.putAll(this.manage.enrichInstitutionAdmin(user.getOrganizationGUID(), claims));
        DefaultOidcUser oidcUser = new DefaultOidcUser(existingToken.getAuthorities(), existingTokenPrincipal.getIdToken(), new OidcUserInfo(claims));
        OAuth2AuthenticationToken newToken = new OAuth2AuthenticationToken((OAuth2User)oidcUser, existingToken.getAuthorities(), existingToken.getAuthorizedClientRegistrationId());
        SecurityContextHolder.getContext().setAuthentication((Authentication)newToken);
        this.securityContextRepository.saveContext(SecurityContextHolder.getContext(), servletRequest, servletResponse);
    }

    @GetMapping(value={"roles/{roleId}"})
    public ResponseEntity<List<Invitation>> byRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /roles/%s by user %s", roleId, user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        List invitations = this.invitationRepository.findByStatusAndRoles_role(Status.OPEN, role);
        return ResponseEntity.ok((Object)invitations);
    }

    @GetMapping(value={"search"})
    @Transactional(readOnly=true)
    public ResponseEntity<Page<Map<String, Object>>> search(@Parameter(hidden=true) User user, @RequestParam(value="roleId", required=false) Long roleId, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection) {
        Page invitationsPage;
        LOG.debug((Object)String.format("GET /search for invitations %s", user.getEduPersonPrincipalName()));
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        boolean queryHasText = StringUtils.hasText((String)query);
        query = queryHasText ? URLDecoder.decode((String)query, Charset.defaultCharset()) : query;
        String parsedQuery = queryHasText ? FullSearchQueryParser.parse((String)query) : "";
        boolean noSearchTokens = parsedQuery.equals("*");
        if (roleId == null) {
            UserPermissions.assertSuperUser((User)user);
            if (queryHasText && !noSearchTokens) {
                invitationsPage = this.invitationRepository.searchByStatusPageWithKeyword(Status.OPEN.name(), parsedQuery, (Pageable)pageable);
            } else if (noSearchTokens) {
                query = ((String)query).toUpperCase() + "%";
                invitationsPage = this.invitationRepository.searchByStatusPageWithStrictSearch(Status.OPEN.name(), (String)query, (Pageable)pageable);
            } else {
                invitationsPage = this.invitationRepository.searchByStatusPage(Status.OPEN.name(), (Pageable)pageable);
            }
        } else {
            Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
            UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
            if (queryHasText && !noSearchTokens) {
                invitationsPage = this.invitationRepository.searchByStatusAndRoleWithKeywordPage(Status.OPEN.name(), role.getId(), parsedQuery, (Pageable)pageable);
            } else if (noSearchTokens) {
                query = ((String)query).toUpperCase() + "%";
                invitationsPage = this.invitationRepository.searchByStatusAndRoleWithStrictSearch(Status.OPEN.name(), role.getId(), (String)query, (Pageable)pageable);
            } else {
                invitationsPage = this.invitationRepository.searchByStatusAndRolePage(Status.OPEN.name(), role.getId(), (Pageable)pageable);
            }
        }
        if (invitationsPage.getTotalElements() == 0L) {
            return ResponseEntity.ok((Object)invitationsPage);
        }
        List<Long> invitationIdentifiers = invitationsPage.getContent().stream().map(m -> (Long)m.get("id")).toList();
        List rolesAndManageIdentifiers = this.invitationRepository.findRoles(invitationIdentifiers);
        Map<Long, List<Map>> rolesGroupedByInvitation = rolesAndManageIdentifiers.stream().collect(Collectors.groupingBy(m -> (Long)m.get("id")));
        List<Map> invitations = invitationsPage.getContent().stream().map(invitationMap -> {
            HashMap<String, List<Object>> copy = new HashMap<String, List<Object>>((Map<String, List<Object>>)invitationMap);
            List aggregatedRoles = (List)rolesGroupedByInvitation.get((Long)invitationMap.get("id"));
            if (CollectionUtils.isEmpty((Collection)aggregatedRoles)) {
                copy.put("roles", Collections.emptyList());
                return copy;
            }
            Map<Long, List<Map>> rolesGroupedByRole = aggregatedRoles.stream().collect(Collectors.groupingBy(m -> (Long)m.get("role_id")));
            List<Map> roles = rolesGroupedByRole.entrySet().stream().map(entry -> Map.of("id", entry.getKey(), "name", ((Map)((List)entry.getValue()).getFirst()).get("name"), "manageIdentifiers", ((List)entry.getValue()).stream().map(m -> m.get("manage_id")).toList())).toList();
            copy.put("roles", roles);
            return copy;
        }).toList();
        return Pagination.of((Page)invitationsPage, invitations);
    }

    private void checkEmailEquality(User user, Invitation invitation) {
        if (invitation.isEnforceEmailEquality() && !invitation.getEmail().equalsIgnoreCase(user.getEmail())) {
            throw new InvitationEmailMatchingException(String.format("Invitation email %s does not match user email %s", invitation.getEmail(), user.getEmail()));
        }
    }

    private void checkCrmUniqueOrganisation(User user, Invitation invitation) {
        if (StringUtils.hasText((String)invitation.getCrmContactId()) && StringUtils.hasText((String)user.getCrmContactId()) && user.getCrmContactId().equals(invitation.getCrmContactId()) && !user.getCrmOrganisationId().equals(invitation.getCrmOrganisationId())) {
            throw new InvitationUniqueCrmOrganisationException(String.format("User %s is not allowed to accept an invitation from Organisation %s, because it already has roles for Organisation %s", user.getEmail(), invitation.getCrmOrganisationId(), user.getCrmOrganisationId()));
        }
    }

    @Generated
    public MailBox getMailBox() {
        return this.mailBox;
    }

    @Generated
    public Manage getManage() {
        return this.manage;
    }

    @Generated
    public InvitationRepository getInvitationRepository() {
        return this.invitationRepository;
    }

    @Generated
    public RoleRepository getRoleRepository() {
        return this.roleRepository;
    }
}

