/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.api.InvitationResource;
import invite.api.Results;
import invite.config.HashGenerator;
import invite.exception.NotAllowedException;
import invite.exception.NotFoundException;
import invite.logging.AccessLogger;
import invite.logging.Event;
import invite.mail.MailBox;
import invite.manage.Manage;
import invite.model.Authority;
import invite.model.Invitation;
import invite.model.InvitationRequest;
import invite.model.InvitationResponse;
import invite.model.InvitationRole;
import invite.model.Invite;
import invite.model.Provisionable;
import invite.model.RecipientInvitationURL;
import invite.model.Role;
import invite.model.User;
import invite.repository.InvitationRepository;
import invite.security.RemoteUser;
import invite.security.RemoteUserPermissions;
import invite.security.UserPermissions;
import invite.validation.EmailFormatValidator;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class InvitationOperations {
    private static final Log LOG = LogFactory.getLog(InvitationOperations.class);
    private final EmailFormatValidator emailFormatValidator = new EmailFormatValidator();
    private final InvitationResource invitationResource;

    public InvitationOperations(InvitationResource invitationResource) {
        this.invitationResource = invitationResource;
    }

    public ResponseEntity<InvitationResponse> sendInvitation(InvitationRequest invitationRequest, User user, RemoteUser remoteUser) {
        List requestInvites;
        ArrayList<Invite> invites;
        invitationRequest.verify();
        Authority intendedAuthority = invitationRequest.getIntendedAuthority();
        if (!List.of(Authority.INSTITUTION_ADMIN, Authority.SUPER_USER).contains(intendedAuthority) && CollectionUtils.isEmpty((Collection)invitationRequest.getRoleIdentifiers())) {
            throw new NotAllowedException("Invitation for non-super-user or institution-admin must contain at least one role");
        }
        List<Role> requestedRoles = invitationRequest.getRoleIdentifiers().stream().map(id -> this.invitationResource.getRoleRepository().findById(id).filter(role -> !StringUtils.hasText((String)role.getCrmRoleId())).orElseThrow(() -> new NotFoundException("Role not found"))).toList();
        if (user != null) {
            UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        } else {
            RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, requestedRoles);
        }
        boolean isOverrideSettingsAllowed = requestedRoles.stream().allMatch(Role::isOverrideSettingsAllowed);
        if (!isOverrideSettingsAllowed) {
            invitationRequest.setEduIDOnly(requestedRoles.stream().anyMatch(Role::isEduIDOnly));
            invitationRequest.setEnforceEmailEquality(requestedRoles.stream().anyMatch(Role::isEnforceEmailEquality));
            if (intendedAuthority.equals((Object)Authority.GUEST)) {
                Instant latest = InvitationOperations.calculateInvitationExpiry(requestedRoles);
                invitationRequest.setRoleExpiryDate(latest);
            }
        }
        if ((invites = invitationRequest.getInvitesWithInternalPlaceholderIdentifiers()) == null) {
            invites = new ArrayList<Invite>();
        }
        if ((requestInvites = invitationRequest.getInvites()) != null) {
            invites.addAll(requestInvites.stream().map(invite -> new Invite(invite, null)).toList());
        }
        List<Invitation> invitations = invites.stream().filter(invite -> {
            boolean valid = this.emailFormatValidator.isValid(invite.getEmail());
            if (!valid) {
                LOG.debug((Object)("Not sending invalid email for invitation: " + invite.getEmail()));
            }
            return valid;
        }).map(invite -> new Invitation(intendedAuthority, HashGenerator.generateRandomHash(), invite.getEmail(), invitationRequest.isEnforceEmailEquality(), invitationRequest.isEduIDOnly(), invitationRequest.getRequestedAuthnContext(), invitationRequest.isGuestRoleIncluded(), invitationRequest.getMessage(), invitationRequest.getLanguage(), user, invitationRequest.getExpiryDate(), invitationRequest.getRoleExpiryDate(), requestedRoles.stream().map(InvitationRole::new).collect(Collectors.toSet()), invite.getInternalPlaceholderIdentifier())).toList();
        if (user == null) {
            invitations.forEach(invitation -> invitation.setRemoteApiUser(remoteUser.getName()));
        }
        if (intendedAuthority.equals((Object)Authority.INSTITUTION_ADMIN)) {
            invitations.forEach(invitation -> invitation.setOrganizationGUID(user.isSuperUser() ? invitationRequest.getOrganizationGUID() : user.getOrganizationGUID()));
        }
        this.invitationResource.getInvitationRepository().saveAll(invitations);
        List groupedProviders = this.invitationResource.getManage().getGroupedProviders(requestedRoles);
        MailBox mailBox = this.invitationResource.getMailBox();
        List<RecipientInvitationURL> recipientInvitationURLs = invitations.stream().map(invitation -> new RecipientInvitationURL(invitation.getEmail(), mailBox.inviteMailURL(invitation))).toList();
        if (!invitationRequest.isSuppressSendingEmails()) {
            invitations.forEach(invitation -> {
                Optional idpName = InvitationOperations.identityProviderName((Manage)this.invitationResource.getManage(), (Invitation)invitation);
                mailBox.sendInviteMail((Provisionable)(user == null ? remoteUser : user), invitation, groupedProviders, invitationRequest.getLanguage(), idpName);
            });
        }
        invitations.forEach(invitation -> AccessLogger.invitation((Log)LOG, (Event)Event.Created, (Invitation)invitation));
        InvitationResponse invitationResponse = new InvitationResponse(HttpStatus.CREATED.value(), invitations.stream().map(Invitation::getId).toList(), recipientInvitationURLs);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)invitationResponse);
    }

    public static Instant calculateInvitationExpiry(List<Role> requestedRoles) {
        Integer defaultExpiryDays = requestedRoles.stream().filter(role -> role.getDefaultExpiryDays() != null).max(Comparator.comparingInt(Role::getDefaultExpiryDays)).map(Role::getDefaultExpiryDays).orElse(0);
        Instant now = Instant.now();
        Instant defaultExpiryDate = requestedRoles.stream().filter(role -> role.getDefaultExpiryDate() != null).max(Comparator.comparing(Role::getDefaultExpiryDate)).map(Role::getDefaultExpiryDate).orElse(now);
        Instant expiryByDays = now.plus((long)defaultExpiryDays.intValue(), ChronoUnit.DAYS);
        return expiryByDays.isAfter(defaultExpiryDate) ? expiryByDays : defaultExpiryDate;
    }

    public ResponseEntity<Map<String, Integer>> resendInvitation(Long id, User user, RemoteUser remoteUser) {
        String name = user != null ? user.getEduPersonPrincipalName() : remoteUser.getDisplayName();
        LOG.debug((Object)String.format("/resendInvitation/%s by user %s", id, name));
        InvitationRepository invitationRepository = this.invitationResource.getInvitationRepository();
        Invitation invitation = (Invitation)invitationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Invitation not found"));
        List<Role> requestedRoles = invitation.getRoles().stream().map(InvitationRole::getRole).toList();
        Authority intendedAuthority = invitation.getIntendedAuthority();
        if (user != null) {
            UserPermissions.assertValidInvitation((User)user, (Authority)intendedAuthority, requestedRoles);
        } else {
            RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, requestedRoles);
        }
        List groupedProviders = this.invitationResource.getManage().getGroupedProviders(requestedRoles);
        User provisionable = user != null ? user : remoteUser;
        Optional idpName = InvitationOperations.identityProviderName((Manage)this.invitationResource.getManage(), (Invitation)invitation);
        this.invitationResource.getMailBox().sendInviteMail((Provisionable)provisionable, invitation, groupedProviders, invitation.getLanguage(), idpName);
        if (invitation.getExpiryDate().isBefore(Instant.now())) {
            invitation.setExpiryDate(Instant.now().plus(Period.ofDays(14)));
            invitationRepository.save((Object)invitation);
        }
        AccessLogger.invitation((Log)LOG, (Event)Event.Resend, (Invitation)invitation);
        return Results.createResult();
    }

    public static Optional<String> identityProviderName(Manage manage, Invitation invitation) {
        return Optional.ofNullable(invitation.getOrganizationGUID()).map(organisationGUID -> manage.identityProvidersByInstitutionalGUID(organisationGUID)).stream().flatMap(Collection::stream).findFirst().map(idp -> (String)idp.get("name:en"));
    }
}

