/*
 * Decompiled with CFR 0.152.
 */
package invite.cron;

import invite.cron.Executable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNodeLeader {
    private static final Log LOG = LogFactory.getLog(AbstractNodeLeader.class);
    private final String lockName;
    private final DataSource dataSource;

    protected AbstractNodeLeader(String lockName, DataSource dataSource) {
        this.lockName = lockName;
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void perform(String name, Executable executable) {
        block31: {
            boolean lockAcquired;
            Connection conn;
            block30: {
                block28: {
                    block29: {
                        conn = null;
                        lockAcquired = false;
                        conn = this.dataSource.getConnection();
                        lockAcquired = this.tryGetLock(conn, this.lockName);
                        if (lockAcquired) break block28;
                        LOG.info((Object)String.format("Another node is running %s, skipping this one", name));
                        this.cleanupStaleLocks(conn, 60);
                        if (!lockAcquired) break block29;
                        try {
                            this.releaseLock(conn, this.lockName);
                            LOG.info((Object)String.format("Lock released for %s", name));
                        }
                        catch (Exception e) {
                            LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e);
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ignored) {
                            LOG.warn((Object)String.format("Failed to close lock %s", name));
                        }
                    }
                    return;
                }
                LOG.info((Object)String.format("Lock acquired for %s", name));
                executable.execute();
                LOG.info((Object)String.format("Executable %s completed successfully", name));
                if (!lockAcquired) break block30;
                try {
                    this.releaseLock(conn, this.lockName);
                    LOG.info((Object)String.format("Lock released for %s", name));
                }
                catch (Exception e) {
                    LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ignored) {
                    LOG.warn((Object)String.format("Failed to close lock %s", name));
                }
            }
            break block31;
            catch (Throwable e) {
                block32: {
                    try {
                        LOG.error((Object)String.format("Error occurred in %s", name), e);
                        if (!lockAcquired) break block32;
                    }
                    catch (Throwable throwable) {
                        if (lockAcquired) {
                            try {
                                this.releaseLock(conn, this.lockName);
                                LOG.info((Object)String.format("Lock released for %s", name));
                            }
                            catch (Exception e2) {
                                LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e2);
                            }
                        }
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Exception ignored) {
                                LOG.warn((Object)String.format("Failed to close lock %s", name));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.releaseLock(conn, this.lockName);
                        LOG.info((Object)String.format("Lock released for %s", name));
                    }
                    catch (Exception e3) {
                        LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e3);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ignored) {
                        LOG.warn((Object)String.format("Failed to close lock %s", name));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryGetLock(Connection conn, String name) throws Exception {
        try {
            boolean bl;
            block12: {
                conn.setAutoCommit(false);
                PreparedStatement ps = conn.prepareStatement("INSERT INTO distributed_locks (lock_name, acquired_at) VALUES (?, NOW())");
                try {
                    ps.setString(1, name);
                    ps.executeUpdate();
                    conn.commit();
                    bl = true;
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        conn.rollback();
                        boolean bl2 = false;
                        conn.setAutoCommit(true);
                        return bl2;
                    }
                }
                ps.close();
            }
            return bl;
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    private void releaseLock(Connection conn, String name) throws Exception {
        try (PreparedStatement ps = conn.prepareStatement("DELETE FROM distributed_locks WHERE lock_name = ?");){
            ps.setString(1, name);
            ps.executeUpdate();
        }
    }

    private void cleanupStaleLocks(Connection conn, int timeoutMinutes) throws Exception {
        try (PreparedStatement ps = conn.prepareStatement("DELETE FROM distributed_locks WHERE acquired_at < NOW() - INTERVAL ? MINUTE");){
            ps.setInt(1, timeoutMinutes);
            ps.executeUpdate();
        }
    }
}

