/*
 * Decompiled with CFR 0.152.
 */
package invite.aggregation;

import invite.manage.EntityType;
import invite.manage.Manage;
import invite.model.Authority;
import invite.model.Role;
import invite.model.User;
import invite.model.UserRole;
import invite.provision.scim.GroupURN;
import invite.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/external/v1/aa"}, produces={"application/json"})
@SecurityRequirement(name="basic_auth")
public class AttributeAggregatorController {
    private static final Log LOG = LogFactory.getLog(AttributeAggregatorController.class);
    private static final String AUTORISATIE = "autorisatie";
    private static final String ID = "id";
    private final UserRepository userRepository;
    private final Manage manage;
    private final String groupUrnPrefix;

    public AttributeAggregatorController(UserRepository userRepository, Manage manage, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix) {
        this.userRepository = userRepository;
        this.manage = manage;
        this.groupUrnPrefix = groupUrnPrefix;
    }

    @GetMapping(value={"/{unspecified_id}"})
    @PreAuthorize(value="hasRole('ATTRIBUTE_AGGREGATION')")
    public ResponseEntity<List<Map<String, String>>> getGroupMemberships(@PathVariable(value="unspecified_id") String unspecifiedId, @RequestParam(value="SPentityID") String spEntityId) {
        Optional optionalProvider;
        try {
            optionalProvider = this.manage.providerByEntityID(EntityType.SAML20_SP, spEntityId).or(() -> this.manage.providerByEntityID(EntityType.OIDC10_RP, spEntityId));
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error in communication with Manage", (Throwable)e);
            optionalProvider = Optional.empty();
        }
        if (optionalProvider.isEmpty()) {
            LOG.debug((Object)String.format("AA request for unknown service: %s", spEntityId));
            return ResponseEntity.ok(Collections.emptyList());
        }
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(unspecifiedId);
        if (optionalUser.isEmpty()) {
            LOG.debug((Object)String.format("AA request for unknown user: %s", unspecifiedId));
            return ResponseEntity.ok(Collections.emptyList());
        }
        User user = (User)optionalUser.get();
        user.setLastActivity(Instant.now());
        this.userRepository.save((Object)user);
        Map provider = (Map)optionalProvider.get();
        List userRoleList = user.getUserRoles().stream().filter(userRole -> userRole.getRole().applicationsUsed().stream().anyMatch(application -> application.getManageId().equals(provider.get(ID)))).filter(userRole -> userRole.getAuthority().equals((Object)Authority.GUEST) || userRole.isGuestRoleIncluded()).map(arg_0 -> this.parseUserRole(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        List<Map> autorisatieRoles = userRoleList.stream().filter(m -> m.containsKey(AUTORISATIE)).toList();
        if (!autorisatieRoles.isEmpty()) {
            Role role = user.getUserRoles().stream().map(userRole -> userRole.getRole()).filter(r -> StringUtils.hasText((String)r.getCrmRoleId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Won't happen"));
            userRoleList.add(Map.of(AUTORISATIE, "urn:mace:surfnet.nl:surfnet.nl:sab:organizationCode:" + role.getCrmOrganisationCode()));
            userRoleList.add(Map.of(AUTORISATIE, "urn:mace:surfnet.nl:surfnet.nl:sab:organizationGUID:" + role.getCrmOrganisationId()));
        }
        LOG.debug((Object)String.format("Returning %o roles for AA request for user: %s and service %s", userRoleList.size(), unspecifiedId, spEntityId));
        return ResponseEntity.ok((Object)userRoleList);
    }

    private Map<String, String> parseUserRole(UserRole userRole) {
        Role role = userRole.getRole();
        String urn = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        return Map.of(StringUtils.hasText((String)role.getCrmRoleId()) ? AUTORISATIE : ID, urn);
    }
}

