/*
 * Decompiled with CFR 0.152.
 */
package invite.eduid;

import invite.eduid.EduIDProvision;
import invite.exception.RemoteException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EduID {
    private static final Log LOG = LogFactory.getLog(EduID.class);
    private final String uri;
    private final RestTemplate restTemplate;
    private final HttpHeaders headers;

    public EduID(@Value(value="${myconext.uri}") String uri, @Value(value="${myconext.username}") String userName, @Value(value="${myconext.password}") String password) {
        this.uri = uri;
        this.restTemplate = new RestTemplate();
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(userName, password));
        this.headers = this.initHttpHeaders();
    }

    public String provisionEduid(EduIDProvision eduIDProvision) {
        HttpEntity requestEntity = new HttpEntity((Object)eduIDProvision, (MultiValueMap)this.headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.uri, HttpMethod.POST, requestEntity, EduIDProvision.class, new Object[0]);
            String eduIDValue = ((EduIDProvision)responseEntity.getBody()).getEduIDValue();
            LOG.info((Object)String.format("eduID %s for institution %s is eduID %s after eduID provisioning", eduIDProvision.getEduIDValue(), eduIDProvision.getInstitutionGUID(), eduIDValue));
            return eduIDValue;
        }
        catch (RuntimeException e) {
            throw new RemoteException(HttpStatus.BAD_REQUEST, "Error in provisionEduid", (Throwable)e);
        }
    }

    private HttpHeaders initHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }
}

