/*
 * Decompiled with CFR 0.152.
 */
package invite.provision.scim;

import invite.model.User;
import invite.provision.Provisioning;
import invite.provision.ScimUserIdentifier;
import invite.provision.scim.Email;
import invite.provision.scim.Name;
import invite.provision.scim.PhoneNumber;
import invite.provision.scim.UserRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class UserRequest
implements Serializable {
    private static final Log LOG = LogFactory.getLog(UserRequest.class);
    private final List<String> schemas = Collections.singletonList("urn:ietf:params:scim:schemas:core:2.0:User");
    private String externalId;
    private String userName;
    private final Name name;
    private String id;
    private final String displayName;
    private final boolean active = true;
    private final List<Email> emails;
    private final List<PhoneNumber> phoneNumbers;

    public UserRequest(User user, Provisioning provisioning) {
        String resolvedUserName;
        this.userName = resolvedUserName = this.resolveUserName(user, provisioning);
        this.externalId = resolvedUserName;
        this.name = new Name(user.getName(), user.getFamilyName(), user.getGivenName());
        this.displayName = user.getName();
        this.emails = List.of(new Email("other", user.getEmail()));
        this.phoneNumbers = Collections.singletonList(new PhoneNumber("+31600000000"));
        if (StringUtils.hasText((String)user.getInternalPlaceholderIdentifier())) {
            this.id = user.getInternalPlaceholderIdentifier();
        }
    }

    public UserRequest(User user, Provisioning provisioning, String remoteScimIdentifier) {
        this(user, provisioning);
        this.id = remoteScimIdentifier;
    }

    public void setInsitutionalEduID(String eduIDValue) {
        this.userName = eduIDValue;
        this.externalId = eduIDValue;
    }

    private String resolveUserName(User user, Provisioning provisioning) {
        String configuredUserName;
        ScimUserIdentifier scimUserIdentifier = provisioning.getScimUserIdentifier();
        String defaultUserName = user.getEduPersonPrincipalName();
        if (scimUserIdentifier == null) {
            return defaultUserName;
        }
        boolean missingScimUserIdentifierValue = false;
        switch (1.$SwitchMap$invite$provision$ScimUserIdentifier[scimUserIdentifier.ordinal()]) {
            case 1: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getSubjectId());
                if (missingScimUserIdentifierValue) {
                    string = defaultUserName;
                    break;
                }
                string = user.getSubjectId();
                break;
            }
            case 2: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getUid());
                if (missingScimUserIdentifierValue) {
                    string = defaultUserName;
                    break;
                }
                string = user.getUid();
                break;
            }
            case 3: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getEmail());
                if (missingScimUserIdentifierValue) {
                    string = defaultUserName;
                    break;
                }
                string = user.getEmail();
                break;
            }
            case 4: {
                String string;
                boolean bl = missingScimUserIdentifierValue = !StringUtils.hasText((String)user.getEduId());
                if (missingScimUserIdentifierValue) {
                    string = defaultUserName;
                    break;
                }
                string = user.getEduId();
                break;
            }
            default: {
                String string = configuredUserName = defaultUserName;
            }
        }
        if (missingScimUserIdentifierValue) {
            LOG.warn((Object)String.format("Missing attribute %s for SCIM provisioning to %s for user %s. Return defaultExternalId %s", scimUserIdentifier, provisioning.getEntityId(), user.getSub(), defaultUserName));
        }
        return configuredUserName;
    }

    @Generated
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Name getName() {
        return this.name;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public boolean isActive() {
        Objects.requireNonNull(this);
        return true;
    }

    @Generated
    public List<Email> getEmails() {
        return this.emails;
    }

    @Generated
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }
}

