/*
 * Decompiled with CFR 0.152.
 */
package manage.validations;

import java.util.Optional;
import org.everit.json.schema.FormatValidator;
import org.springframework.util.StringUtils;

public class BasicAuthenticationUsernameFormatValidator
implements FormatValidator {
    public Optional<String> validate(String subject) {
        if (!StringUtils.hasText((String)subject)) {
            return Optional.of(String.format("The username in basic authentication must not be empty", subject));
        }
        if (subject.contains(":")) {
            return Optional.of(String.format("[%s] is not a valid basic authentication user", subject));
        }
        return Optional.empty();
    }

    public String formatName() {
        return "basic-authentication-user";
    }
}

