/*
 * Decompiled with CFR 0.152.
 */
package manage.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.conf.Features;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FeatureService {
    private final List<Features> enabledFeatures;

    public FeatureService(@Value(value="${features}") String features) {
        List allFeatures = Arrays.stream(Features.values()).map(Enum::name).collect(Collectors.toList());
        this.enabledFeatures = null != features && !features.isEmpty() ? Stream.of(features.split(",")).filter(feature -> allFeatures.contains(feature.trim().toUpperCase())).map(feature -> Features.valueOf((String)feature.trim().toUpperCase())).collect(Collectors.toList()) : Collections.emptyList();
    }

    public boolean isFeatureEnabled(Features feature) {
        return this.enabledFeatures.contains(feature);
    }
}

