/*
 * Decompiled with CFR 0.152.
 */
package manage.conf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.conf.IndexConfiguration;
import manage.exception.CustomValidationException;
import manage.model.EntityType;
import manage.validations.BooleanFormatValidator;
import manage.validations.CertificateFormatValidator;
import manage.validations.JSONFormatValidator;
import manage.validations.LocalEmailFormatValidator;
import manage.validations.NumberFormatValidator;
import manage.validations.PatternFormatValidator;
import manage.validations.URIFormatValidator;
import manage.validations.URLFormatValidator;
import manage.validations.UUIDFormatValidator;
import manage.validations.XMLFormatValidator;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MetaDataAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataAutoConfiguration.class);
    private final Map<String, Schema> schemas;
    private final Map<String, File> templates;
    private final List<Map<String, Object>> schemaRepresentations = new ArrayList();
    private final Map<String, List<IndexConfiguration>> indexConfigurations = new HashMap();
    private final ObjectMapper objectMapper;

    @Autowired
    public MetaDataAutoConfiguration(ObjectMapper objectMapper, @Value(value="${metadata_configuration_path}") Resource metadataConfigurationPath, @Value(value="${metadata_templates_path}") Resource metadataTemplatesPath) throws IOException {
        this.schemas = this.parseConfiguration(metadataConfigurationPath, Arrays.asList(new CertificateFormatValidator(), new NumberFormatValidator(), new BooleanFormatValidator(), new LocalEmailFormatValidator(), new URIFormatValidator(), new URLFormatValidator(), new JSONFormatValidator(), new PatternFormatValidator(), new XMLFormatValidator(), new UUIDFormatValidator()));
        this.objectMapper = objectMapper;
        this.templates = this.parseTemplates(metadataTemplatesPath);
        LOG.info("Finished loading {} metadata configurations", (Object)this.schemas.size());
    }

    public void validate(Map<String, Object> data, String type) throws JsonProcessingException {
        Schema schema = this.schemas.computeIfAbsent(type, key -> {
            throw new IllegalArgumentException(String.format("No schema defined for %s", key));
        });
        String json = this.objectMapper.writeValueAsString(data);
        JSONObject jsonObject = new JSONObject(new JSONTokener(json));
        try {
            schema.validate((Object)jsonObject);
        }
        catch (ValidationException e) {
            throw new CustomValidationException(e);
        }
    }

    public Set<String> schemaNames() {
        return this.schemas.keySet();
    }

    public Map<String, Object> metaDataTemplate(String type) {
        File file = this.templates.computeIfAbsent(type, key -> {
            throw new IllegalArgumentException(String.format("No template defined for %s", key));
        });
        return this.parseTemplate(file);
    }

    public List<IndexConfiguration> indexConfigurations(String schemaType) {
        return this.indexConfigurations.getOrDefault(schemaType, Collections.emptyList());
    }

    public List<Map<String, Object>> schemaRepresentations() {
        return this.schemaRepresentations;
    }

    public Map<String, Object> schemaRepresentation(EntityType entityType) {
        Optional<Map> schemaRepresentationOptional = this.schemaRepresentations().stream().filter(map -> map.get("title").equals(entityType.getType())).findFirst();
        return schemaRepresentationOptional.orElseThrow(() -> new IllegalArgumentException(String.format("The %s schema does not exists", entityType.getType())));
    }

    public Schema schema(String type) {
        if (!this.schemas.containsKey(type)) {
            throw new IllegalArgumentException(String.format("The %s schema does not exists", type));
        }
        return (Schema)this.schemas.get(type);
    }

    public Schema anySchema() {
        return this.schemas.getOrDefault(EntityType.SP.getType(), (Schema)this.schemas.values().stream().findAny().orElseThrow(IllegalAccessError::new));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private Map<String, Schema> parseConfiguration(Resource metadataConfigurationPath, List<FormatValidator> validators) throws IOException {
        File[] files = metadataConfigurationPath.getFile().listFiles();
        List schemaFiles = Stream.of(files).filter(file -> file.getName().endsWith("schema.json")).collect(Collectors.toList());
        Assert.notEmpty(schemaFiles, (String)String.format("No schema.json files defined in %s", metadataConfigurationPath.getFilename()));
        return schemaFiles.stream().map(file -> this.parse(file, validators, Stream.of(files).filter(f -> f.getName().equals(file.getName().replace("schema", "addendum"))).findAny())).collect(Collectors.toMap(Schema::getTitle, schema -> schema));
    }

    private Map<String, File> parseTemplates(Resource metadataTemplatesPath) throws IOException {
        Object[] templates = metadataTemplatesPath.getFile().listFiles((dir, name) -> name.endsWith("template.json"));
        Assert.notEmpty((Object[])templates, (String)String.format("No template.json files defined in %s", metadataTemplatesPath.getFilename()));
        return Stream.of(templates).collect(Collectors.toMap(file -> file.getName().substring(0, file.getName().indexOf(".template.json")), file -> file));
    }

    private Schema parse(File file, List<FormatValidator> validators, Optional<File> addendum) {
        JSONObject jsonObject = new JSONObject(new JSONTokener((InputStream)this.fileInputStream(file)));
        Optional<JSONObject> optionalAddendum = addendum.map(addendumFile -> new JSONObject(new JSONTokener((InputStream)this.fileInputStream(addendumFile))));
        if (optionalAddendum.isPresent()) {
            jsonObject = this.deepMerge(jsonObject, optionalAddendum.get());
        }
        SchemaLoader.SchemaLoaderBuilder schemaLoaderBuilder = SchemaLoader.builder().schemaJson(jsonObject);
        validators.forEach(arg_0 -> ((SchemaLoader.SchemaLoaderBuilder)schemaLoaderBuilder).addFormatValidator(arg_0));
        Schema schema = schemaLoaderBuilder.build().load().build();
        this.addIndexes(schema.getTitle(), jsonObject);
        this.schemaRepresentations.add(jsonObject.toMap());
        return schema;
    }

    private JSONObject deepMerge(JSONObject source, JSONObject addendum) {
        Stream.of(JSONObject.getNames((JSONObject)addendum)).forEach(name -> {
            Object value = addendum.get(name);
            if (!source.has(name)) {
                source.put(name, value);
            } else if (value instanceof JSONObject) {
                JSONObject addendumValueJson = (JSONObject)value;
                JSONObject jsonObject = source.getJSONObject(name);
                this.deepMerge(jsonObject, addendumValueJson);
            } else {
                source.put(name, value);
            }
        });
        return source;
    }

    private FileInputStream fileInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("%s not found", file.getAbsolutePath()));
        }
    }

    private Map<String, Object> parseTemplate(File file) {
        try {
            return (Map)this.objectMapper.readValue(file, Map.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void addIndexes(String schemaType, JSONObject json) {
        if (json.has("indexes")) {
            List indexes = json.getJSONArray("indexes").toList();
            List indexConfigurations = indexes.stream().map(obj -> {
                Map map = (Map)Map.class.cast(obj);
                return new IndexConfiguration((String)map.get("name"), (String)map.get("type"), (List)map.get("fields"), ((Boolean)map.get("unique")).booleanValue());
            }).collect(Collectors.toList());
            this.indexConfigurations.put(schemaType, indexConfigurations);
        }
    }
}

