/*
 * Decompiled with CFR 0.152.
 */
package manage.shibboleth.mock;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import manage.shibboleth.mock.MockShibbolethFilter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class MockShibbolethFilter
extends GenericFilterBean {
    public static final String SAML2_USER = "saml2_user.com";
    private static final boolean isSuperUSer = true;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            SetHeader wrapper = new SetHeader((HttpServletRequest)servletRequest);
            wrapper.setHeader("name-id", SAML2_USER);
            wrapper.setHeader("displayname", "John Doe");
            wrapper.setHeader("schacHomeOrganization", "http://mock-idp");
            wrapper.setHeader("is-member-of", "urn:collab:group:test.surfteams.nl:nl:surfnet:diensten:manage_super_users");
            filterChain.doFilter((ServletRequest)wrapper, servletResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

