/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import com.github.cloudyrock.mongock.driver.api.driver.ConnectionDriver;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.SpringDataMongoV3Driver;
import com.github.cloudyrock.spring.v5.MongockSpring5;
import java.util.Arrays;
import manage.conf.MetaDataAutoConfiguration;
import manage.mongo.EpochConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;

@Configuration
public class MongoConfiguration {
    @Bean
    public MongoCustomConversions customConversions() {
        return new MongoCustomConversions(Arrays.asList(new EpochConverter()));
    }

    @Bean
    public MongockSpring5.MongockApplicationRunner mongockApplicationRunner(ApplicationContext springContext, MetaDataAutoConfiguration metaDataAutoConfiguration, MongoTemplate mongoTemplate) {
        SpringDataMongoV3Driver driver = SpringDataMongoV3Driver.withDefaultLock((MongoTemplate)mongoTemplate);
        driver.disableTransaction();
        return ((MongockSpring5.Builder)((MongockSpring5.Builder)((MongockSpring5.Builder)MongockSpring5.builder().setDriver((ConnectionDriver)driver).addChangeLogsScanPackage("manage.mongo")).addDependency((Object)metaDataAutoConfiguration)).setSpringContext(springContext)).buildApplicationRunner();
    }

    @Bean
    public MongoTransactionManager transactionManager(MongoTemplate mongoTemplate) {
        return new MongoTransactionManager(mongoTemplate.getMongoDatabaseFactory());
    }
}

