/*
 * Decompiled with CFR 0.152.
 */
package manage.validations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.everit.json.schema.FormatValidator;
import org.xml.sax.SAXException;

public class XMLFormatValidator
implements FormatValidator {
    private static final String FEATURE_DISABLE_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";

    public Optional<String> validate(String subject) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature(FEATURE_DISABLE_DOCTYPE, true);
            factory.newDocumentBuilder().parse(new ByteArrayInputStream(subject.getBytes()));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return Optional.of(e.toString());
        }
        return Optional.empty();
    }

    public String formatName() {
        return "xml";
    }
}

