/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.List;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class ServiceProviderDeleteHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final MetaDataRepository metaDataRepository;

    public ServiceProviderDeleteHook(MetaDataAutoConfiguration metaDataAutoConfiguration, MetaDataRepository metaDataRepository) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.RP.getType()) || metaData.getType().equals(EntityType.SP.getType());
    }

    public MetaData preDelete(MetaData metaData, AbstractUser user) {
        String entityId = this.entityId(metaData);
        String query = String.format("{\"data.serviceProviderIds.name\":\"%s\"}", entityId);
        List<MetaData> policies = this.metaDataRepository.findRaw(EntityType.PDP.getType(), query).stream().filter(md -> ((List)md.getData().get("serviceProviderIds")).size() == 1).toList();
        if (!policies.isEmpty()) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PDP.getType());
            List<ValidationException> exceptions = policies.stream().map(policy -> new ValidationException(schema, String.format("The policy %s uses this %s. First remove this %s from the policy.", policy.getData().get("name"), metaData.getType(), metaData.getType()))).toList();
            ValidationException.throwFor((Schema)schema, exceptions);
        }
        return metaData;
    }
}

