/*
 * Decompiled with CFR 0.152.
 */
package manage.web;

import java.security.Principal;
import manage.shibboleth.FederatedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class FederatedUserHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger LOG = LoggerFactory.getLogger(FederatedUserHandlerMethodArgumentResolver.class);

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(FederatedUser.class);
    }

    public FederatedUser resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        PreAuthenticatedAuthenticationToken token;
        Principal userPrincipal = webRequest.getUserPrincipal();
        Object principal = null;
        if (userPrincipal instanceof PreAuthenticatedAuthenticationToken ? (principal = (token = (PreAuthenticatedAuthenticationToken)userPrincipal).getPrincipal()) instanceof FederatedUser : userPrincipal instanceof UsernamePasswordAuthenticationToken && (principal = (token = (UsernamePasswordAuthenticationToken)userPrincipal).getPrincipal()) instanceof FederatedUser) {
            return (FederatedUser)principal;
        }
        LOG.warn(String.format("Can not extract FederatedUser from userPrincipal %s name %s principal %s webRequest %s", userPrincipal.getClass().getCanonicalName(), userPrincipal.getName(), principal, webRequest.getDescription(true)));
        return null;
    }
}

