/*
 * Decompiled with CFR 0.152.
 */
package manage.validations;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;

public class LocalEmailFormatValidator
implements FormatValidator {
    private static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%&+-]+@[A-Z0-9.-]+\\.[A-Z]{2,16}$", 2);
    private final Pattern VALID_URL_REGEX = Pattern.compile("^(http|https)://(.*)$");

    public Optional<String> validate(String subject) {
        Matcher emailMatcher = VALID_EMAIL_ADDRESS_REGEX.matcher(subject);
        if (emailMatcher.find()) {
            return Optional.empty();
        }
        Matcher urlMatcher = this.VALID_URL_REGEX.matcher(subject);
        if (urlMatcher.find()) {
            return Optional.empty();
        }
        return Optional.of(String.format("[%s] is not a valid email address and not a valid URL", subject));
    }

    public String formatName() {
        return "local-email";
    }
}

