/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import manage.control.RestTemplateIdiom;
import manage.model.MetaData;
import manage.policies.PdpPolicyDefinition;
import manage.repository.MetaDataRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class PdPController {
    private final String decideUrl;
    private final RestTemplate pdpRestTemplate;
    private final MetaDataRepository metaDataRepository;
    private final String parseUrl;
    private final ObjectMapper objectMapper;

    public PdPController(@Value(value="${push.pdp.decide_url}") String decideUrl, @Value(value="${push.pdp.parse_url}") String parseUrl, @Value(value="${push.pdp.user}") String pdpUser, @Value(value="${push.pdp.password}") String pdpPassword, MetaDataRepository metaDataRepository, ObjectMapper objectMapper) {
        this.decideUrl = decideUrl;
        this.parseUrl = parseUrl;
        this.metaDataRepository = metaDataRepository;
        this.pdpRestTemplate = RestTemplateIdiom.buildRestTemplate((String)this.decideUrl, (String)pdpUser, (String)pdpPassword);
        this.objectMapper = objectMapper;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/pdp/decide"})
    public String decideManage(@RequestBody String payload) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)payload, (MultiValueMap)headers);
        return (String)this.pdpRestTemplate.exchange(this.decideUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]).getBody();
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @GetMapping(value={"/client/pdp/conflicts", "/internal/pdp/conflicts"})
    public Map<String, List<MetaData>> conflictingPolicies() {
        return this.metaDataRepository.conflictingPolicies();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/pdp/parse"})
    public Map<String, String> xml(@RequestBody Map<String, Object> data) {
        MetaData metaData = new MetaData("policy", data);
        metaData.initial(UUID.randomUUID().toString(), "system", Long.valueOf(1L));
        PdpPolicyDefinition policyDefinition = new PdpPolicyDefinition(metaData);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)policyDefinition, (MultiValueMap)headers);
        String res = (String)this.pdpRestTemplate.exchange(this.parseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]).getBody();
        return Map.of("xml", res);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/pdp/parse-json"})
    public Map<String, Object> json(@RequestBody Map<String, Object> data) {
        MetaData metaData = new MetaData("policy", data);
        metaData.initial(UUID.randomUUID().toString(), "system", Long.valueOf(1L));
        PdpPolicyDefinition policyDefinition = new PdpPolicyDefinition(metaData);
        Map map = (Map)this.objectMapper.convertValue((Object)policyDefinition, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        map.entrySet().removeIf(entry -> {
            Object value = entry.getValue();
            return value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty();
        });
        return map;
    }
}

