/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.control.RestTemplateIdiom;
import manage.format.EngineBlockFormatter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.PushOptions;
import manage.model.Scope;
import manage.policies.PdpPolicyDefinition;
import manage.repository.MetaDataRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Component
@RestController
public class DatabaseController {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseController.class);
    private static final int BATCH_SIZE = 500;
    private final RestTemplate restTemplate;
    private final String pushUri;
    private final RestTemplate oidcRestTemplate;
    private final String oidcPushUri;
    private final boolean oidcEnabled;
    private final boolean excludeEduGainImported;
    private final boolean excludeOidcRP;
    private final boolean excludeSRAM;
    private final MetaDataRepository metaDataRepository;
    private final Environment environment;
    private final String pdpPushUri;
    private final RestTemplate pdpRestTemplate;
    private final boolean pdpEnabled;

    @Autowired
    DatabaseController(MetaDataRepository metaDataRepository, @Value(value="${push.eb.url}") String pushUri, @Value(value="${push.eb.user}") String user, @Value(value="${push.eb.password}") String password, @Value(value="${push.eb.exclude_edugain_imports}") boolean excludeEduGainImported, @Value(value="${push.eb.exclude_oidc_rp}") boolean excludeOidcRP, @Value(value="${push.eb.exclude_sram}") boolean excludeSRAM, @Value(value="${push.oidc.url}") String oidcPushUri, @Value(value="${push.oidc.user}") String oidcUser, @Value(value="${push.oidc.password}") String oidcPassword, @Value(value="${push.pdp.url}") String pdpPushUri, @Value(value="${push.pdp.user}") String pdpUser, @Value(value="${push.pdp.password}") String pdpPassword, @Value(value="${push.pdp.enabled}") boolean pdpEnabled, @Value(value="${push.oidc.enabled}") boolean oidcEnabled, Environment environment) {
        this.metaDataRepository = metaDataRepository;
        this.pushUri = pushUri;
        this.restTemplate = RestTemplateIdiom.buildRestTemplate((String)pushUri, (String)user, (String)password);
        this.excludeEduGainImported = excludeEduGainImported;
        this.excludeOidcRP = excludeOidcRP;
        this.excludeSRAM = excludeSRAM;
        this.oidcRestTemplate = RestTemplateIdiom.buildRestTemplate((String)oidcPushUri, (String)oidcUser, (String)oidcPassword);
        this.oidcPushUri = oidcPushUri;
        this.oidcEnabled = oidcEnabled;
        this.pdpRestTemplate = RestTemplateIdiom.buildRestTemplate((String)pdpPushUri, (String)pdpUser, (String)pdpPassword);
        this.pdpPushUri = pdpPushUri;
        this.pdpEnabled = pdpEnabled;
        this.environment = environment;
    }

    public ResponseEntity<Map> doPush(PushOptions pushOptions) {
        ResponseEntity response;
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            return new ResponseEntity(Map.of("eb", Map.of("status", "OK"), "pdp", Map.of("status", "OK"), "oidc", Map.of("status", "OK")), (HttpStatusCode)HttpStatus.OK);
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        List policies = this.pushPreviewPdP();
        if (pushOptions.isIncludePdP() && this.pdpEnabled) {
            try {
                this.pdpRestTemplate.put(this.pdpPushUri, (Object)policies, new Object[0]);
                result.put("pdp", Map.of("status", "OK"));
            }
            catch (HttpStatusCodeException e) {
                String message = String.format("Error in push to PDP (%s) status %s and response %s", this.pdpPushUri, e.getStatusCode(), e.getResponseBodyAsString());
                LOG.error(message);
                return new ResponseEntity(Map.of("message", message), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                String message = String.format("Error in push to PDP (%s) error %s", this.pdpPushUri, e.getMessage());
                LOG.error(message);
                return new ResponseEntity(Map.of("message", message), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else {
            result.put("pdp", Map.of("status", "OK"));
        }
        if (pushOptions.isIncludeEB()) {
            Map json = this.doPushPreview(policies);
            try {
                response = this.restTemplate.postForEntity(this.pushUri, (Object)json, String.class, new Object[0]);
                String body = (String)response.getBody();
                result.put("eb", Map.of("status", response.getStatusCode().is2xxSuccessful() ? "OK" : "ERROR", "response", StringUtils.hasText((String)body) ? body : ""));
            }
            catch (HttpStatusCodeException e) {
                String message = String.format("Error in push to EngineBlock (%s) status %s and response %s", this.pushUri, e.getStatusCode(), e.getResponseBodyAsString());
                LOG.error(message);
                return new ResponseEntity(Map.of("message", message), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                String message = String.format("Error in push to EngineBlock (%s) error %s", this.pushUri, e.getMessage());
                LOG.error(message);
                return new ResponseEntity(Map.of("message", message), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else {
            result.put("eb", Map.of("status", "OK"));
        }
        if (!this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"})) && this.oidcEnabled && pushOptions.isIncludeOIDC()) {
            String message;
            List filteredEntities = this.pushPreviewOIDC();
            try {
                response = this.oidcRestTemplate.postForEntity(this.oidcPushUri, (Object)filteredEntities, Void.class, new Object[0]);
                result.put("oidc", Map.of("status", response.getStatusCode().is2xxSuccessful() ? "OK" : "ERROR"));
            }
            catch (HttpStatusCodeException e) {
                message = String.format("Error in push to OIDC (%s) status %s and response %s", this.oidcPushUri, e.getStatusCode(), e.getResponseBodyAsString());
                LOG.error(message);
                return new ResponseEntity(Map.of("message", message), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception e) {
                message = String.format("Error in push to OIDC (%s) error %s", this.oidcPushUri, e.getMessage());
                LOG.error(message);
                return new ResponseEntity(Map.of("message", message), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else {
            result.put("oidc", Map.of("status", "OK"));
        }
        return new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
    }

    private List<PdpPolicyDefinition> pushPreviewPdP() {
        List<PdpPolicyDefinition> policies = this.metaDataRepository.findAllByType(EntityType.PDP.getType()).stream().map(PdpPolicyDefinition::new).filter(PdpPolicyDefinition::isActive).collect(Collectors.toList());
        return policies;
    }

    private List<MetaData> pushPreviewOIDC() {
        List relyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RP.getType());
        List resourceServers = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.RS.getType());
        List scopes = this.metaDataRepository.getMongoTemplate().findAll(Scope.class);
        Map<String, Scope> scopesMapped = scopes.stream().collect(Collectors.toMap(Scope::getName, scope -> scope));
        resourceServers.forEach(rs -> {
            rs.setType(EntityType.RP.getType());
            Map metaDataFields = rs.metaDataFields();
            metaDataFields.put("isResourceServer", true);
            List scopeList = (List)metaDataFields.get("scopes");
            if (!CollectionUtils.isEmpty((Collection)scopeList)) {
                List transformedScope = scopeList.stream().map(scope -> scopesMapped.getOrDefault(scope, null)).filter(Objects::nonNull).collect(Collectors.toList());
                metaDataFields.put("scopes", transformedScope);
            }
        });
        if (!this.excludeSRAM) {
            List sramRelyingParties = this.metaDataRepository.getMongoTemplate().findAll(MetaData.class, EntityType.SRAM.getType());
            sramRelyingParties.forEach(sramEntity -> sramEntity.metaDataFields().put("coin:collab_enabled", true));
            relyingParties.addAll(sramRelyingParties);
        }
        relyingParties.forEach(rp -> {
            Map metaDataFields = rp.metaDataFields();
            metaDataFields.put("isResourceServer", false);
            metaDataFields.remove("scopes");
        });
        relyingParties.addAll(resourceServers);
        List<MetaData> filteredEntities = relyingParties.stream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toList());
        return filteredEntities;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreview"})
    public Map<String, Map<String, Map<String, Object>>> pushPreview() {
        List policies = this.pushPreviewPdP();
        return this.doPushPreview(policies);
    }

    private Map<String, Map<String, Map<String, Object>>> doPushPreview(List<PdpPolicyDefinition> policies) {
        EngineBlockFormatter formatter = new EngineBlockFormatter();
        List serviceProviders = this.metaDataRepository.getMongoTemplate().stream(new Query().cursorBatchSize(500), MetaData.class, EntityType.SP.getType()).toList();
        Stream<Object> spStream = serviceProviders.parallelStream();
        if (this.excludeEduGainImported) {
            spStream = spStream.filter(metaData -> {
                Map fields = metaData.metaDataFields();
                boolean imported = Boolean.TRUE.equals(fields.get("coin:imported_from_edugain"));
                boolean push = Boolean.TRUE.equals(fields.get("coin:push_enabled"));
                return !imported || push;
            });
        }
        Map serviceProvidersToPush = spStream.filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toConcurrentMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseServiceProvider(arg_0)));
        List identityProviders = this.metaDataRepository.getMongoTemplate().stream(new Query().cursorBatchSize(500), MetaData.class, EntityType.IDP.getType()).toList();
        this.filterOutNullDisableConsentExplanations(identityProviders);
        Map identityProvidersToPush = identityProviders.parallelStream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toConcurrentMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseIdentityProvider(arg_0)));
        if (!this.excludeOidcRP) {
            List relyingParties = this.metaDataRepository.getMongoTemplate().stream(new Query().cursorBatchSize(500), MetaData.class, EntityType.RP.getType()).toList();
            Map oidcClientsToPush = relyingParties.parallelStream().filter(metaData -> !this.excludeFromPush(metaData.metaDataFields())).collect(Collectors.toConcurrentMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseOidcClient(arg_0)));
            serviceProvidersToPush.putAll(oidcClientsToPush);
        }
        if (!this.excludeSRAM) {
            List<MetaData> sramServices = this.metaDataRepository.getMongoTemplate().stream(new Query().cursorBatchSize(500), MetaData.class, EntityType.SRAM.getType()).toList();
            sramServices.forEach(sram -> sram.metaDataFields().put("coin:collab_enabled", true));
            Map sramToPush = sramServices.parallelStream().collect(Collectors.toConcurrentMap(MetaData::getId, arg_0 -> ((EngineBlockFormatter)formatter).parseServiceProvider(arg_0)));
            serviceProvidersToPush.putAll(sramToPush);
        }
        serviceProvidersToPush.putAll(identityProvidersToPush);
        Set allServiceProviderIds = policies.parallelStream().filter(p -> p.isActive() && !p.isIdpPolicy()).flatMap(p -> p.getServiceProviderIds().stream()).collect(Collectors.toSet());
        Set allIdentityProviderIds = policies.parallelStream().filter(p -> p.isActive() && p.isIdpPolicy()).flatMap(p -> p.getIdentityProviderIds().stream()).collect(Collectors.toSet());
        serviceProvidersToPush.values().parallelStream().forEach(provider -> {
            boolean addDecision;
            String type = (String)provider.get("type");
            Map metadata = (Map)provider.computeIfAbsent("metadata", k -> new HashMap());
            Map coin = (Map)metadata.computeIfAbsent("coin", k -> new HashMap());
            String entityID = provider.getOrDefault("name", "");
            boolean bl = addDecision = type.equals(EntityType.SP.getJanusDbValue()) ? allServiceProviderIds.contains(entityID) : allIdentityProviderIds.contains(entityID);
            if (addDecision) {
                coin.put("policy_enforcement_decision_required", "1");
            } else {
                coin.remove("policy_enforcement_decision_required");
            }
        });
        HashMap<String, Map<String, Map<String, Object>>> results = new HashMap<String, Map<String, Map<String, Object>>>();
        results.put("connections", serviceProvidersToPush);
        return results;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreviewOIDC"})
    public List<MetaData> pushPreviewOIDCEndpoint() {
        return this.pushPreviewOIDC();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @GetMapping(value={"/client/playground/pushPreviewPdP"})
    public List<PdpPolicyDefinition> pushPreviewPdPEndpoint() {
        return this.pushPreviewPdP();
    }

    private boolean excludeFromPush(Map metaDataFields) {
        Boolean excludeFromPush = metaDataFields.getOrDefault("coin:exclude_from_push", false);
        if (excludeFromPush instanceof String) {
            return "1".equals(excludeFromPush);
        }
        return excludeFromPush;
    }

    public void filterOutNullDisableConsentExplanations(List<MetaData> identityProviders) {
        identityProviders.forEach(idp -> {
            Object disableConsentData = idp.getData().get("disableConsent");
            if (disableConsentData instanceof List) {
                List disableConsent = (List)disableConsentData;
                disableConsent.forEach(disableConsentEntry -> {
                    if (disableConsentEntry instanceof Map) {
                        Map disableConsentMap = (Map)disableConsentEntry;
                        disableConsentMap.entrySet().removeIf(entry -> entry.getValue() == null);
                    }
                });
            }
        });
    }
}

