/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.util.StringUtils;

public class CertificateDataDuplicationHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;

    public CertificateDataDuplicationHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        String type = metaData.getType();
        return Stream.of(EntityType.IDP, EntityType.SP, EntityType.SRAM).anyMatch(entityType -> entityType.getType().equals(type));
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        this.validate(newMetaData);
        return super.prePut(previous, newMetaData, user);
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        this.validate(metaData);
        return super.prePost(metaData, user);
    }

    private void validate(MetaData metaData) {
        Map metaDataFields = metaData.metaDataFields();
        List<String> nonEmptyCerts = Stream.of("certData", "certData2", "certData3").map(key -> (String)metaDataFields.get(key)).filter(StringUtils::hasText).toList();
        HashSet<String> uniqueCerts = new HashSet<String>(nonEmptyCerts);
        if (nonEmptyCerts.size() != uniqueCerts.size()) {
            ArrayList<ValidationException> failures = new ArrayList<ValidationException>();
            Schema schema = this.metaDataAutoConfiguration.schema(metaData.getType());
            failures.add(new ValidationException(schema, "Certificate data fields must not contain duplicate values. Fields: \"certData\" \"certData2\" \"certData3\"", "certData", null));
            ValidationException.throwFor((Schema)schema, failures);
        }
    }
}

