/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.List;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.EntityIdDuplicationHook;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class EntityIdDuplicationHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final MetaDataRepository metaDataRepository;

    public EntityIdDuplicationHook(MetaDataAutoConfiguration metaDataAutoConfiguration, MetaDataRepository metaDataRepository) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return true;
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        this.validate(metaData, true);
        return metaData;
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        this.validate(newMetaData, false);
        return newMetaData;
    }

    private void validate(MetaData newMetaData, boolean isNew) {
        String entityId = this.entityId(newMetaData);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        EntityType entityType = EntityType.fromType((String)newMetaData.getType());
        switch (1.$SwitchMap$manage$model$EntityType[entityType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                entityTypes.add(entityType);
                break;
            }
            case 6: {
                entityTypes.add(entityType);
                entityTypes.add(EntityType.RP);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                entityTypes.addAll(List.of(EntityType.SP, EntityType.SRAM, EntityType.RP));
            }
        }
        List<List> metaDataResults = entityTypes.stream().map(type -> {
            String query = isNew ? String.format("{\"data.entityid\": \"%s\"}", entityId) : String.format("{\"data.entityid\": \"%s\",\"_id\":{$ne: \"%s\"}}", entityId, newMetaData.getId());
            return this.metaDataRepository.findRaw(type.getType(), query);
        }).filter(metaDataList -> !metaDataList.isEmpty()).toList();
        if (!metaDataResults.isEmpty()) {
            Schema schema = this.metaDataAutoConfiguration.schema(newMetaData.getType());
            List failures = metaDataResults.stream().flatMap(metaDataList -> metaDataList.stream().map(metaData -> new ValidationException(this.metaDataAutoConfiguration.schema(metaData.getType()), String.format("Duplicate entityid %s in collection %s with id %s", this.entityId(metaData), metaData.getType(), metaData.getId()), null, null))).toList();
            ValidationException.throwFor((Schema)schema, failures);
        }
    }
}

