/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Map;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.util.StringUtils;

public class IdentityProviderBrinCodeHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;

    public IdentityProviderBrinCodeHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.IDP.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        this.validate(newMetaData);
        return super.prePut(previous, newMetaData, user);
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        this.validate(metaData);
        return super.prePost(metaData, user);
    }

    private void validate(MetaData newMetaData) {
        Map metaDataFields = newMetaData.metaDataFields();
        String brinCode = (String)metaDataFields.get("coin:institution_brin");
        String brinCodeSchacHome = (String)metaDataFields.get("coin:institution_brin_schac_home");
        ArrayList<ValidationException> failures = new ArrayList<ValidationException>();
        Schema schema = this.metaDataAutoConfiguration.schema(EntityType.IDP.getType());
        if (StringUtils.hasText((String)brinCode) && !StringUtils.hasText((String)brinCodeSchacHome)) {
            failures.add(new ValidationException(schema, "coin:institution_brin_schac_home is required for an IdP with coin:institution_brin", "coin:institution_brin_schac_home", null));
        }
        if (!StringUtils.hasText((String)brinCode) && StringUtils.hasText((String)brinCodeSchacHome)) {
            failures.add(new ValidationException(schema, "coin:institution_brin is required for an IdP with coin:institution_brin_schac_home", "coin:institution_brin", null));
        }
        ValidationException.throwFor((Schema)schema, failures);
    }
}

