/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.util.StringUtils;

public class SSIDValidationHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final MetaDataRepository metaDataRepository;

    public SSIDValidationHook(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        String type = metaData.getType();
        boolean isRpOrSp = type.equals(EntityType.RP.getType()) || type.equals(EntityType.SP.getType());
        return isRpOrSp && metaData.metaDataFields().containsKey("coin:stepup:requireloa");
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        this.validate(newMetaData);
        return super.prePut(previous, newMetaData, user);
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        this.validate(metaData);
        return super.prePost(metaData, user);
    }

    private void validate(MetaData newMetaData) {
        Map metaDataFields = newMetaData.metaDataFields();
        String loa = (String)metaDataFields.get("coin:stepup:requireloa");
        if (StringUtils.hasText((String)loa)) {
            String entityId = (String)newMetaData.getData().get("entityid");
            List references = this.metaDataRepository.findRaw(EntityType.IDP.getType(), String.format("{\"data.stepupEntities.name\" : \"%s\"}", entityId));
            if (!references.isEmpty()) {
                Schema schema = this.metaDataAutoConfiguration.schema(newMetaData.getType());
                String msg = String.format("Not allowed to configure 'coin:stepup:requireloa'. This SP is already configured as a stepupEntity in IdP: %s", references.stream().map(metaData -> (String)metaData.getData().get("entityid")).collect(Collectors.joining(", ")));
                throw new ValidationException(schema, msg, "stepupEntities", null);
            }
        }
    }
}

