/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.Map;
import java.util.regex.Pattern;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.CollectionUtils;

public class SecretHook
extends MetaDataHookAdapter {
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder(5);
    private final Pattern pattern = Pattern.compile("^\\$2[ayb]\\$.{56}$");
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;

    public SecretHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.RP.getType()) || metaData.getType().equals(EntityType.RS.getType()) || metaData.getType().equals(EntityType.SRAM.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        return this.encryptSecret(newMetaData);
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        return this.encryptSecret(metaData);
    }

    private MetaData encryptSecret(MetaData newMetaData) {
        String secret;
        Map data = newMetaData.metaDataFields();
        if (!CollectionUtils.isEmpty((Map)data) && data.containsKey("secret") && !this.isBCryptEncoded(secret = (String)data.get("secret"))) {
            if (secret == null || secret.trim().length() < 12) {
                Schema schema = this.metaDataAutoConfiguration.schema(newMetaData.getType());
                throw new ValidationException(schema, "Secret has minimal length of 12 characters", "metaDataFields.secret", null);
            }
            String encoded = this.passwordEncoder.encode((CharSequence)secret);
            data.put("secret", encoded);
        }
        return newMetaData;
    }

    boolean isBCryptEncoded(String secret) {
        return this.pattern.matcher(secret).matches();
    }
}

