/*
 * Decompiled with CFR 0.152.
 */
package manage.mongo;

import com.github.cloudyrock.mongock.ChangeLog;
import com.github.cloudyrock.mongock.ChangeSet;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.DistinctIterable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.conf.MetaDataAutoConfiguration;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.Scope;
import manage.mongo.Sequence;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ChangeLog(order="001")
public class MongoChangelog {
    public static final String REVISION_POSTFIX = "_revision";
    public static final String CHANGE_REQUEST_POSTFIX = "_change_request";
    private static final Logger LOG = LoggerFactory.getLogger(MongoChangelog.class);

    @ChangeSet(order="001", id="createCollections", author="okke.harsta@surf.nl")
    public void createCollections(MongoTemplate mongoTemplate) {
        this.doCreateSchemas(mongoTemplate, Arrays.asList("saml20_sp", "saml20_idp", "oidc10_rp"));
        if (!mongoTemplate.collectionExists("sequences")) {
            LOG.info("Creating sequence collection with new start seq {}", (Object)999L);
            mongoTemplate.createCollection("sequences");
            mongoTemplate.save((Object)new Sequence("sequence", Long.valueOf(999L)));
        }
    }

    @ChangeSet(order="002", id="addTextIndexes", author="okke.harsta@surf.nl")
    public void addTextIndexes(MongoTemplate mongoTemplate) {
        this.doAddTestIndexes(mongoTemplate);
    }

    private void doAddTestIndexes(MongoTemplate mongoTemplate) {
        Stream.of(EntityType.values()).forEach(entityType -> {
            TextIndexDefinition textIndexDefinition = new TextIndexDefinition.TextIndexDefinitionBuilder().onField("$**").build();
            mongoTemplate.indexOps(entityType.getType()).createIndex((IndexDefinition)textIndexDefinition);
        });
    }

    @ChangeSet(order="003", id="addDefaultScopes", author="okke.harsta@surf.nl")
    public void addDefaultScopes(MongoTemplate mongoTemplate) {
        if (!mongoTemplate.collectionExists("scopes")) {
            mongoTemplate.remove(new Query(), Scope.class);
            DistinctIterable scopes = mongoTemplate.getCollection(EntityType.RP.getType()).distinct("data.metaDataFields.scopes", String.class);
            scopes.forEach(scope -> mongoTemplate.insert((Object)new Scope(scope, new HashMap(), new HashMap())));
        }
    }

    @ChangeSet(order="004", id="removeSessions", author="okke.harsta@surf.nl", runAlways=true)
    public void removeSessions(MongoTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="005", id="revisionCreatedIndex", author="okke.harsta@surf.nl")
    public void revisionCreatedIndex(MongoTemplate mongoTemplate) {
        Stream.of(EntityType.values()).forEach(entityType -> mongoTemplate.indexOps(entityType.getType()).createIndex((IndexDefinition)new Index("revision.created", Sort.Direction.DESC)));
    }

    @ChangeSet(order="005", id="revisionTerminatedIndex", author="okke.harsta@surf.nl")
    public void revisionTerminatedIndex(MongoTemplate mongoTemplate) {
        Stream.of(EntityType.values()).forEach(entityType -> mongoTemplate.indexOps(entityType.getType().concat(REVISION_POSTFIX)).createIndex((IndexDefinition)new Index("revision.terminated", Sort.Direction.DESC)));
    }

    @ChangeSet(order="006", id="caseInsensitiveIndexEntityID", author="okke.harsta@surf.nl")
    public void caseInsensitiveIndexEntityID(MongoTemplate mongoTemplate) {
        Stream.of(EntityType.values()).filter(entityType -> !entityType.equals((Object)EntityType.STT)).map(EntityType::getType).forEach(val -> {
            IndexOperations indexOperations = mongoTemplate.indexOps(val);
            List indexInfo = indexOperations.getIndexInfo();
            if (indexInfo.stream().anyMatch(info -> info.getName().equals("data.entityid_1"))) {
                indexOperations.dropIndex("data.entityid_1");
            }
            indexOperations.createIndex((IndexDefinition)new Index("data.entityid", Sort.Direction.ASC).unique().collation(Collation.of((String)"en").strength(2)));
        });
    }

    @ChangeSet(order="007", id="moveResourceServers", author="okke.harsta@surf.nl")
    public void moveResourceServers(MongoTemplate mongoTemplate, MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.doCreateSchemas(mongoTemplate, Collections.singletonList(EntityType.RS.getType()));
        Criteria criteria = Criteria.where((String)"data.metaDataFields.isResourceServer").is((Object)true);
        List resourceServers = mongoTemplate.findAllAndRemove(Query.query((CriteriaDefinition)criteria), MetaData.class, EntityType.RP.getType());
        Map schemaRepresentation = metaDataAutoConfiguration.schemaRepresentation(EntityType.RS);
        Map properties = (Map)schemaRepresentation.get("properties");
        Map metaDataFields = (Map)properties.get("metaDataFields");
        Map patternProperties = (Map)metaDataFields.get("patternProperties");
        List patterns = patternProperties.keySet().stream().map(key -> Pattern.compile(key)).collect(Collectors.toList());
        Map simpleProperties = (Map)metaDataFields.get("properties");
        resourceServers.forEach(rs -> this.migrateRelayingPartyToResourceServer(properties, patterns, simpleProperties, rs));
        if (!CollectionUtils.isEmpty((Collection)resourceServers)) {
            BulkWriteResult bulkWriteResult = mongoTemplate.bulkOps(BulkOperations.BulkMode.ORDERED, MetaData.class, EntityType.RS.getType()).insert(resourceServers).execute();
            LOG.info(String.format("Migrated %s relying parties to resource server collection", bulkWriteResult.getInsertedCount()));
        }
        List identifiers = resourceServers.stream().map(metaData -> metaData.getId()).collect(Collectors.toList());
        Criteria revisionCriteria = Criteria.where((String)"revision.parentId").in(identifiers);
        List revisions = mongoTemplate.findAllAndRemove(Query.query((CriteriaDefinition)revisionCriteria), MetaData.class, EntityType.RP.getType().concat(REVISION_POSTFIX));
        revisions.forEach(rev -> this.migrateRelayingPartyToResourceServer(properties, patterns, simpleProperties, rev));
        if (!CollectionUtils.isEmpty((Collection)revisions)) {
            BulkWriteResult bulkWriteResultRevisions = mongoTemplate.bulkOps(BulkOperations.BulkMode.ORDERED, MetaData.class, EntityType.RS.getType().concat(REVISION_POSTFIX)).insert(revisions).execute();
            LOG.info(String.format("Migrated %s relying party revisions to resource server revisions collection", bulkWriteResultRevisions.getInsertedCount()));
        }
    }

    @ChangeSet(order="008", id="removeExtraneousKeys", author="okke.harsta@surf.nl")
    public void removeExtraneousKeys(MongoTemplate mongoTemplate) {
        List relyingParties = mongoTemplate.findAll(MetaData.class, EntityType.RP.getType());
        List<String> extraneousKeysRelyingParties = Arrays.asList("scopes", "isResourceServer");
        relyingParties.forEach(rp -> {
            Map metaDataFields = rp.metaDataFields();
            Set keySet = metaDataFields.keySet();
            if (keySet.stream().anyMatch(key -> extraneousKeysRelyingParties.contains(key))) {
                keySet.removeIf(key -> extraneousKeysRelyingParties.contains(key));
                LOG.info(String.format("Saving %s relying party where extraneousKeys are removed", rp.getData().get("entityid")));
                mongoTemplate.save(rp, EntityType.RP.getType());
            }
        });
        List resourceServers = mongoTemplate.findAll(MetaData.class, EntityType.RS.getType());
        List<String> extraneousKeysResourceServers = Arrays.asList("NameIDFormats:0", "NameIDFormats:1", "NameIDFormats:2");
        resourceServers.forEach(rs -> {
            Map metaDataFields = rs.metaDataFields();
            Set keySet = metaDataFields.keySet();
            if (keySet.stream().anyMatch(key -> extraneousKeysResourceServers.contains(key))) {
                keySet.removeIf(key -> extraneousKeysResourceServers.contains(key));
                LOG.info(String.format("Saving %s relying party where extraneousKeys are removed", rs.getData().get("entityid")));
                mongoTemplate.save(rs, EntityType.RS.getType());
            }
        });
    }

    @ChangeSet(order="009", id="addScopeTitles", author="okke.harsta@surf.nl")
    public void addScopeTitles(MongoTemplate mongoTemplate) {
        List scopes = mongoTemplate.findAll(Scope.class);
        scopes.forEach(scope -> {
            scope.update(scope);
            mongoTemplate.save(scope);
        });
    }

    @ChangeSet(order="010", id="createChangeRequestsCollections", author="okke.harsta@surf.nl")
    public void createChangeRequestsCollections(MongoTemplate mongoTemplate) {
        Stream.of(EntityType.values()).forEach(entityType -> {
            String revisionCollection = entityType.getType().concat(CHANGE_REQUEST_POSTFIX);
            if (!mongoTemplate.collectionExists(revisionCollection)) {
                mongoTemplate.createCollection(revisionCollection);
            }
        });
    }

    @ChangeSet(order="011", id="addProvisioning", author="okke.harsta@surf.nl")
    public void addProvisioning(MongoTemplate mongoTemplate) {
        String revision;
        String schema = EntityType.PROV.getType();
        if (!mongoTemplate.collectionExists(schema)) {
            mongoTemplate.createCollection(schema);
        }
        if (!mongoTemplate.collectionExists(revision = schema.concat(REVISION_POSTFIX))) {
            mongoTemplate.createCollection(revision);
        }
        mongoTemplate.indexOps(revision).createIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
        TextIndexDefinition textIndexDefinition = new TextIndexDefinition.TextIndexDefinitionBuilder().onField("$**").build();
        mongoTemplate.indexOps(schema).createIndex((IndexDefinition)textIndexDefinition);
    }

    @ChangeSet(order="012", id="addTextIndexRS", author="okke.harsta@surf.nl")
    public void addTextIndexRS(MongoTemplate mongoTemplate) {
        String schema = EntityType.RS.getType();
        TextIndexDefinition textIndexDefinition = new TextIndexDefinition.TextIndexDefinitionBuilder().onField("$**").build();
        mongoTemplate.indexOps(schema).createIndex((IndexDefinition)textIndexDefinition);
    }

    @ChangeSet(order="013", id="addPolicy", author="okke.harsta@surf.nl")
    public void addPolicy(MongoTemplate mongoTemplate) {
        String revision;
        String schema = EntityType.PDP.getType();
        if (!mongoTemplate.collectionExists(schema)) {
            mongoTemplate.createCollection(schema);
        }
        if (!mongoTemplate.collectionExists(revision = schema.concat(REVISION_POSTFIX))) {
            mongoTemplate.createCollection(revision);
        }
        mongoTemplate.indexOps(revision).createIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
        TextIndexDefinition textIndexDefinition = new TextIndexDefinition.TextIndexDefinitionBuilder().onField("$**").build();
        mongoTemplate.indexOps(schema).createIndex((IndexDefinition)textIndexDefinition);
    }

    @ChangeSet(order="014", id="clearInvalidARPKeys", author="okke.harsta@surf.nl")
    public void clearInvalidARPKeys(MongoTemplate mongoTemplate) {
        List<String> allowedKeys = List.of("source", "value", "motivation", "release_as", "use_as_nameid");
        List.of(EntityType.RP, EntityType.SP, EntityType.STT).forEach(entityType -> {
            List metaDataList = mongoTemplate.findAll(MetaData.class, entityType.getType());
            metaDataList.forEach(metaData -> {
                Map arp;
                if (metaData.getData().containsKey("arp") && !CollectionUtils.isEmpty((Map)(arp = (Map)metaData.getData().get("arp")))) {
                    Object attributesObject = arp.get("attributes");
                    if (attributesObject instanceof List) {
                        arp.put("attributes", new HashMap());
                        LOG.info(String.format("Saving %s metadata type %s where ARP attributes is a List", metaData.getData().get("entityid"), entityType));
                        mongoTemplate.save(metaData, entityType.getType());
                    } else if (attributesObject instanceof Map) {
                        Map attributes = (Map)arp.get("attributes");
                        if (!CollectionUtils.isEmpty((Map)attributes)) {
                            AtomicBoolean needsSaving = new AtomicBoolean(false);
                            attributes.forEach((arpName, value) -> value.forEach(attribute -> {
                                boolean useAsNameId = attribute.getOrDefault("use_as_nameid", attribute.getOrDefault("use_as_name_id", attribute.getOrDefault("useAsNameId", false)));
                                attribute.put("use_as_nameid", useAsNameId);
                                String releaseAt = (String)attribute.getOrDefault("releaseAs", attribute.get("release_as"));
                                if (StringUtils.hasText((String)releaseAt)) {
                                    attribute.put("release_as", releaseAt);
                                }
                                if (attribute.keySet().removeIf(key -> !allowedKeys.contains(key))) {
                                    needsSaving.set(true);
                                }
                            }));
                            if (needsSaving.get()) {
                                LOG.info(String.format("Saving %s metadata type %s where ARP values are fixed", metaData.getData().get("entityid"), entityType.getType()));
                                mongoTemplate.save(metaData, entityType.getType());
                            }
                        }
                    } else {
                        LOG.info(String.format("Unknown attributes type in metadata %s type %s", metaData.getData().get("entityid"), entityType));
                    }
                }
            });
        });
    }

    @ChangeSet(order="015", id="addSRAMServices", author="okke.harsta@surf.nl")
    public void addSRAMServices(MongoTemplate mongoTemplate) {
        String revision;
        String schema = EntityType.SRAM.getType();
        if (!mongoTemplate.collectionExists(schema)) {
            mongoTemplate.createCollection(schema);
        }
        if (!mongoTemplate.collectionExists(revision = schema.concat(REVISION_POSTFIX))) {
            mongoTemplate.createCollection(revision);
        }
        mongoTemplate.indexOps(revision).createIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
        TextIndexDefinition textIndexDefinition = new TextIndexDefinition.TextIndexDefinitionBuilder().onField("$**").build();
        mongoTemplate.indexOps(schema).createIndex((IndexDefinition)textIndexDefinition);
    }

    @ChangeSet(order="016", id="migrateMultiplicityKeys", author="okke.harsta@surf.nl")
    public void migrateMultiplicityKeys(MongoTemplate mongoTemplate) {
        List identityProviders = mongoTemplate.findAll(MetaData.class, EntityType.IDP.getType());
        identityProviders.forEach(metaData -> {
            Map metaDataFields = metaData.metaDataFields();
            List.of("en", "nl", "pt").forEach(language -> {
                String keywords;
                String name = (String)metaDataFields.get("name:" + language);
                if (StringUtils.hasText((String)name)) {
                    metaDataFields.put("DiscoveryName:0:" + language, name);
                }
                if (StringUtils.hasText((String)(keywords = (String)metaDataFields.get("keywords:" + language)))) {
                    metaDataFields.put("keywords:0:" + language, keywords);
                }
                metaDataFields.remove("keywords:" + language);
            });
            LOG.info(String.format("Saving %s metadata type %s where DiscoveryName and keywords are migrated", metaData.getData().get("entityid"), EntityType.IDP.getType()));
            mongoTemplate.save(metaData, EntityType.IDP.getType());
        });
    }

    @ChangeSet(order="017", id="migrateApplicationTags", author="okke.harsta@surf.nl")
    public void migrateApplicationTags(MongoTemplate mongoTemplate) {
        String tags = IOUtils.toString((InputStream)new ClassPathResource("migration.tags.csv").getInputStream(), (Charset)Charset.defaultCharset());
        String[] lines = tags.split("\\R");
        HashMap mappings = new HashMap();
        Stream.of(lines).forEach(s -> {
            String[] splitted = s.split(",");
            mappings.put(splitted[0].trim().toLowerCase(), splitted[1].trim().toLowerCase());
        });
        List serviceProviders = mongoTemplate.findAll(MetaData.class, EntityType.SP.getType());
        List relyingParties = mongoTemplate.findAll(MetaData.class, EntityType.RP.getType());
        serviceProviders.addAll(relyingParties);
        serviceProviders.forEach(metaData -> {
            Map metaDataFields = metaData.metaDataFields();
            String value = (String)metaDataFields.get("coin:ss:type_of_service:en");
            if (StringUtils.hasText((String)value)) {
                ArrayList applicationTags = new ArrayList();
                Stream.of(value.split(",")).forEach(s -> {
                    String key = s.trim().toLowerCase();
                    if (mappings.containsKey(key)) {
                        applicationTags.add((String)mappings.get(key));
                    }
                });
                if (!applicationTags.isEmpty()) {
                    metaDataFields.put("application_tags", applicationTags);
                    LOG.info(String.format("Saving %s metadata type %s where coin:ss:type_of_service is duplicated in application tags", metaData.getData().get("entityid"), metaData.getType()));
                    mongoTemplate.save(metaData, metaData.getType());
                }
            }
        });
    }

    @ChangeSet(order="018", id="removePdpPolicyRequired", author="okke.harsta@surf.nl")
    public void removePdpPolicyRequired(MongoTemplate mongoTemplate) {
        String pdpPolicyRequired = "coin:policy_enforcement_decision_required";
        Arrays.asList(EntityType.SP, EntityType.RP, EntityType.IDP, EntityType.SRAM, EntityType.STT).parallelStream().forEach(entityType -> {
            List metaDataList = mongoTemplate.findAll(MetaData.class, entityType.getType());
            metaDataList.forEach(metaData -> {
                Map metaDataFields = metaData.metaDataFields();
                if (metaDataFields.containsKey(pdpPolicyRequired)) {
                    metaDataFields.remove(pdpPolicyRequired);
                    LOG.info("Removed {} from entity {} in collection {}", new Object[]{pdpPolicyRequired, metaData.getData().get("entityid"), entityType.getType()});
                    mongoTemplate.save(metaData, entityType.getType());
                }
            });
        });
    }

    private void migrateRelayingPartyToResourceServer(Map<String, Map<String, Object>> properties, List<Pattern> patterns, Map<String, Object> simpleProperties, MetaData rs) {
        rs.setType(EntityType.RS.getType());
        rs.getData().entrySet().removeIf(entry -> !properties.containsKey(entry.getKey()));
        rs.metaDataFields().entrySet().removeIf(entry -> !simpleProperties.containsKey(entry.getKey()) && patterns.stream().noneMatch(pattern -> pattern.matcher((CharSequence)entry.getKey()).matches()));
    }

    private void doCreateSchemas(MongoTemplate mongoTemplate, List<String> connectionTypes) {
        connectionTypes.forEach(schema -> {
            if (!mongoTemplate.collectionExists(schema)) {
                mongoTemplate.createCollection(schema);
                String revision = schema.concat(REVISION_POSTFIX);
                mongoTemplate.createCollection(revision);
                mongoTemplate.indexOps(revision).createIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
            }
        });
        connectionTypes.forEach(collection -> {
            IndexOperations indexOps = mongoTemplate.indexOps(collection);
            indexOps.getIndexInfo().stream().filter(indexInfo -> indexInfo.getName().contains("data.eid")).forEach(indexInfo -> indexOps.dropIndex(indexInfo.getName()));
            indexOps.createIndex((IndexDefinition)new Index("data.eid", Sort.Direction.ASC).unique());
            indexOps.getIndexInfo().stream().filter(indexInfo -> indexInfo.getName().contains("entityid")).forEach(indexInfo -> indexOps.dropIndex(indexInfo.getName()));
            indexOps.createIndex((IndexDefinition)new Index("data.entityid", Sort.Direction.ASC).unique().collation(Collation.of((String)"en").strength(2)));
            indexOps.createIndex((IndexDefinition)new Index("data.state", Sort.Direction.ASC));
            if (!collection.equals(EntityType.RS.getType())) {
                indexOps.createIndex((IndexDefinition)new Index("data.allowedall", Sort.Direction.ASC));
                indexOps.createIndex((IndexDefinition)new Index("data.allowedEntities.name", Sort.Direction.ASC));
                indexOps.createIndex((IndexDefinition)new Index("data.metaDataFields.coin:institution_id", Sort.Direction.ASC));
            }
        });
        connectionTypes.stream().map(s -> s + REVISION_POSTFIX).forEach(collection -> {
            IndexOperations indexOps = mongoTemplate.indexOps(collection);
            indexOps.createIndex((IndexDefinition)new Index("revision.parentId", Sort.Direction.ASC));
        });
    }
}

